<?php
namespace Newland\NeosMetaTags\Extractor;

/*
 * This file is part of the "neos-meta-tags" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Media\Domain\Model\ImageInterface;
use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Configuration\ConfigurationManager;
use Neos\Flow\Annotations as Flow;
use Newland\NeosCommon\Service\NodeService;
use Newland\NeosMetaTags\Service\ThumbnailService;

abstract class BaseExtractor
{
    /**
     * @var ConfigurationManager
     * @Flow\Inject()
     */
    protected $configurationManager;
    /**
     * @var NodeService
     * @Flow\Inject()
     */
    protected $nodeService;
    /**
     * @var ThumbnailService
     * @Flow\Inject()
     */
    protected $thumbnailService;
    /**
     * @var array
     * @Flow\InjectConfiguration()
     */
    protected $configuration;

    /**
     * @var string
     * @Flow\InjectConfiguration(path="Neos.Seo.twitterCard.siteHandle")
     */
    protected $twitterHandle;

    protected function appendWebsite(?string $title, Node $node): string
    {
        $parts = [];
        if ($title !== null) {
            $parts[] = $title;
        }
        if ($this->configuration['title']['appendWebsite'] ?? false) {
            $website = $this->nodeService->getCurrentSite($node)->getName();
            if (!empty($website)) {
                $parts[] = $website;
            }
        }
        return implode(' | ', $parts);
    }

    protected function getPresetFromTwitterCardType(string $twitterCardType): string
    {
        if ($twitterCardType === 'summary_large_image') {
            return 'Neos.Seo:TwitterCard.SummaryCardLargeImage';
        }
        return 'Neos.Seo:TwitterCard.SummaryCard';
    }

    protected function getOgImagePresetFromAsset(ImageInterface $asset): string
    {
        if ($asset->isOrientationLandscape()) {
            return 'Neos.Seo:OpenGraph.Landscape';
        }

        return 'Neos.Seo:OpenGraph.Square';
    }
}
