<?php declare(strict_types=1);
namespace Newland\NeosMetaTags\Eel\Helper;

/*
 * This file is part of the "neos-meta-tags" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Flow\Mvc\ActionRequest;
use Neos\Flow\Mvc\RequestInterface;
use Neos\Flow\Annotations as Flow;
use Newland\NeosMetaTags\Domain\Model\MetaData;
use Newland\NeosMetaTags\Service\MetaDataService;

class MetaDataHelper implements ProtectedContextAwareInterface
{
    /**
     * @var MetaDataService
     * @Flow\Inject()
     */
    protected $metaDataService;

    /**
     * @param string $methodName
     * @return boolean
     */
    public function allowsCallOfMethod($methodName): bool
    {
        return true;
    }

    /**
     * @param Node $node
     * @param ActionRequest|RequestInterface $request
     * @return MetaData
     */
    public function getMetaData(Node $node, RequestInterface $request): MetaData
    {
        return $this->metaDataService->getMetaData($node, $request);
    }

    public function getTitle(Node $node, RequestInterface $request): ?string
    {
        return $this->metaDataService->getTitle($node, $request, true);
    }

    public function getDescription(Node $node, RequestInterface $request): ?string
    {
        return $this->metaDataService->getDescription($node, $request);
    }
}
