<?php
namespace Newland\NeosCommon\Tests\Unit\Service;


use Neos\Flow\Configuration\ConfigurationManager;
use Neos\Flow\Tests\FunctionalTestCase;
use Neos\Flow\Tests\UnitTestCase;
use Newland\NeosCommon\Tests\Unit\Service\Fixtures\RegionServiceFixture;
use Symfony\Component\Yaml\Yaml;

class AbstractRegionServiceTest extends FunctionalTestCase
{

    /** @var RegionServiceFixture */
    protected $subject;

    public function setUp(): void
    {
        $this->subject = new RegionServiceFixture();

        $regions = (new Yaml())->parseFile(__DIR__ . '/Fixtures/Regions.yaml');
        $this->subject->setRegionsAvailable($regions);
        $this->subject->setRegionsEnabled(array_keys($regions));
    }

    /**
     * @param array $regionsEnabled
     * @param array $expectedZips
     * @dataProvider provideZipData
     */
    public function testGetsZipsFromRegionKeys(array $regionsEnabled, array $expectedZips): void
    {
        $this->assertEquals(
            $expectedZips,
            $this->subject->getZipsFromRegionKeys($regionsEnabled)
        );
    }

    public function provideZipData(): array
    {
        return [
            // Simple zip mapping
            [ [ 'konstanz' ], [ '78462', '78464', '78465', '78467' ] ],

            // Simple children
            [ [ 'bodensee' ], [ '78462', '78464', '78465', '78467', '78315', '78224' ] ],

            // Multiple inputs: No duplicates should exist
            [ [ 'konstanz', 'bodensee' ], [ '78462', '78464', '78465', '78467', '78315', '78224' ] ],

            // Does not exist
            [ [ 'foobar' ], [] ],

            // Contains cycles
            [ [ 'looptown' ], [] ]
        ];
    }

}
