<?php
namespace Newland\NeosCommon\Models;

/*
 * This file is part of the "neos-common" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class MetaData
{
    /** @var string */
    protected $title = '';

    /** @var string */
    protected $description = '';

    /** @var string */
    protected $url = '';

    /** @var string */
    protected $image = '';

    /** @var string */
    protected $type = 'article';

    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    public function getDescription(): string
    {
        return strip_tags((string) $this->description);
    }

    public function setDescription(string $description): void
    {
        $this->description = $description;
    }

    public function getDescriptionTrimmed(): string
    {
        $description = $this->getDescription();

        if (strlen($description) > 150) {
            $description = substr($description, 0, 147) . '...';
        }

        return $description;
    }

    public function getUrl(): string
    {
        return $this->url;
    }

    public function setUrl(string $url): void
    {
        $this->url = $url;
    }

    public function getImage(): string
    {
        return $this->image;
    }

    public function setImage(string $image): void
    {
        $this->image = $image;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }
}
