<?php declare(strict_types=1);

/*
 * Copyright (c) 2022, land in sicht AG
 *
 * www.land-in-sicht.de - All rights reserved.
 *
 * This is proprietary software. Unauthorized copying
 * of this file, via any medium, is strictly prohibited.
 */

namespace Unit\Service;

use Newland\NeosFiltering\Service\DataSourceHelper;
use PHPUnit\Framework\TestCase;

class DataSourceHelperTest extends TestCase
{
    public function testExtractsZeroValuesAsValidDataSourceOptions(): void
    {
        $data = [
            [
                'value' => 'foo:0',
                'queryString' => '0',
                'attributeType' => "number",
            ],
            [
                'value' => 'foo:1',
                'queryString' => '1',
                'attributeType' => "number",
            ],
            [
                'value' => 'foo:2',
                'queryString' => '2',
                'attributeType' => "number",
            ],
        ];

        $actualCallback = static function ($state) use ($data) {
            return DataSourceHelper::extractValidDataSourceOptionsBasedOnStateStrings($data, $state);
        };

        self::assertCount(1, $actualCallback([ '0' ]));
        self::assertCount(1, $actualCallback([ '2' ]));
        self::assertCount(0, $actualCallback([ '3' ]));
        self::assertCount(0, $actualCallback([]));
    }
}
