<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Tests\Unit\Items;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosFiltering\Items\PaginationInput;
use Newland\NeosFiltering\Items\Root;
use Newland\NeosFiltering\Tests\Factory\ExampleEntityFactory;
use Newland\NeosFiltering\Tests\Fixture\Domain\Model\ExampleEntity;

class PaginationInputTest extends ItemTestCase
{

    /** @var PaginationInput */
    protected $subject;

    /** @var Root */
    protected $root;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = new PaginationInput();
        $this->subject->setQueryString('page');
        $this->subject->setConfiguration([ 'pageSize' => 10 ]);

        $this->root = new Root();
        $this->root->addItem($this->subject);
    }

    public function testPaginatesTheResultsWhenUsedInRoot(): void
    {
        (new ExampleEntityFactory($this->objectManager))->createMultiple(15);
        $this->subject->setConfiguration([ 'pageSize' => 10 ]);

        $this->assertCount(10, $this->root->applyToQuery($this->initializeEmptyQuery())->getQuery()->execute());

        $this->root->setState([ 'page' => 2 ]);
        $this->assertCount(5, $this->root->applyToQuery($this->initializeEmptyQuery())->getQuery()->execute());
    }

}
