<?php declare(strict_types=1);
namespace Newland\NeosFiltering\Tests\Fixture\Domain\Model;

use Doctrine\Common\Collections\Collection;
use Neos\Flow\Annotations as Flow;
use Doctrine\ORM\Mapping as ORM;
use Ramsey\Uuid\UuidInterface;

/**
 * @Flow\Entity()
 * @ORM\Table("newland_neosfiltering_testing_category")
 */
class ExampleCategory
{

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue(strategy="UUID")
     * @ORM\Column(type="guid", unique=TRUE)
     * @var string|UuidInterface
     */
    public $uuid;

    /**
     * @ORM\ManyToMany(targetEntity="\Newland\NeosFiltering\Tests\Fixture\Domain\Model\ExampleEntity", mappedBy="categories",
     *     fetch="EAGER")
     * @ORM\JoinTable(name="newland_neosfiltering_testing_entity_category_mm")
     * @var Collection<ExampleEntity>
     */
    public $entities;


    /**
     * @var string
     */
    public $name;
}
