<?php declare(strict_types=1);

namespace Newland\NeosFiltering\Items;

use Doctrine\ORM\Query\Expr;
use Newland\Contracts\Neos\Filter\Expression;
use Newland\Contracts\Neos\Filter\FilterItem;
use Newland\NeosFiltering\Traits\FilterItemCommon;
use Newland\NeosFiltering\Traits\HasInvisibleState;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * A simple filter item that renders nothing but adds a direct foo="value"
 * mapping for where or having.
 */
class DirectEquals implements FilterItem
{
    use FilterItemCommon,
        HasInvisibleState;

    /** @var string */
    protected $statement;

    public function setStatement(string $statement): void
    {
        $this->statement = $statement;
    }

    public function queryExpression(Expr $expr): Expression
    {
        return Expression::where($this->statement);
    }

    public function render(RenderingContextInterface $renderingContext)
    {
        return null;
    }
}
