<?php
namespace Neos\Neos\Tests\Unit\Domain\Repository\Configuration;

/*
 * This file is part of the Neos.Neos package.
 *
 * (c) Contributors of the Neos Project - www.neos.io
 *
 * This package is Open Source Software. For the full copyright and license
 * information, please view the LICENSE file which was distributed with this
 * source code.
 */
use Neos\Flow\Persistence\QueryResultInterface;
use Neos\Flow\Tests\UnitTestCase;
use Neos\Neos\Domain\Model\Domain;
use Neos\Neos\Domain\Repository\DomainRepository;
use Neos\Neos\Domain\Service\DomainMatchingStrategy;

/**
 * Testcase for the Domain Repository
 *
 */
class DomainRepositoryTest extends UnitTestCase
{
    /**
     * @test
     */
    public function findByHostInvokesTheDomainMatchingStrategyToFindDomainsMatchingTheGivenHost()
    {
        $mockDomains = [];
        $mockDomains[] = $this->getMockBuilder(Domain::class)->disableOriginalConstructor()->getMock();
        $mockDomains[] = $this->getMockBuilder(Domain::class)->disableOriginalConstructor()->getMock();
        $mockDomains[] = $this->getMockBuilder(Domain::class)->disableOriginalConstructor()->getMock();

        $expectedDomains = [$mockDomains[0], $mockDomains[2]];

        $mockDomainMatchingStrategy = $this->getMockBuilder(DomainMatchingStrategy::class)->disableOriginalConstructor()->getMock();
        $mockDomainMatchingStrategy->expects($this->any())->method('getSortedMatches')->with('myhost', $mockDomains)->will($this->returnValue($expectedDomains));

        $mockResult = $this->createMock(QueryResultInterface::class);
        $mockResult->expects($this->once())->method('toArray')->will($this->returnValue($mockDomains));
        $domainRepository = $this->getAccessibleMock(DomainRepository::class, ['findAll'], [], '', false);
        $domainRepository->expects($this->once())->method('findAll')->will($this->returnValue($mockResult));
        $domainRepository->_set('domainMatchingStrategy', $mockDomainMatchingStrategy);

        $actualDomains = $domainRepository->findByHost('myhost');
        $this->assertSame($expectedDomains, $actualDomains);
    }
}
