/* VIE.js 2.1.0 - Semantic Interaction Toolkit
by Henri Bergius and the IKS Project. Available under the MIT license.
See http://viejs.org for more information
*/(function(){var t=this,e=t.jQuery,i=t.Backbone,r=t._,n=t.VIE=function(t){this.config=t?t:{},this.services={},this.jQuery=e,this.entities=new this.Collection([],{vie:this}),this.Entity.prototype.entities=this.entities,this.Entity.prototype.entityCollection=this.Collection,this.Entity.prototype.vie=this,this.Namespaces.prototype.vie=this,this.namespaces=new this.Namespaces(this.config.baseNamespace?this.config.baseNamespace:"http://viejs.org/ns/",{owl:"http://www.w3.org/2002/07/owl#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",schema:"http://schema.org/",foaf:"http://xmlns.com/foaf/0.1/",geo:"http://www.w3.org/2003/01/geo/wgs84_pos#",dbpedia:"http://dbpedia.org/ontology/",dbprop:"http://dbpedia.org/property/",skos:"http://www.w3.org/2004/02/skos/core#",xsd:"http://www.w3.org/2001/XMLSchema#",sioc:"http://rdfs.org/sioc/ns#",dcterms:"http://purl.org/dc/terms/"}),this.Type.prototype.vie=this,this.Types.prototype.vie=this,this.Attribute.prototype.vie=this,this.Attributes.prototype.vie=this,this.types=new this.Types,this.types.add("owl:Thing"),this.config.classic===!0&&(this.RDFa=new this.ClassicRDFa(this),this.RDFaEntities=new this.ClassicRDFaEntities(this),this.EntityManager=new this.ClassicEntityManager(this),this.cleanup=function(){this.entities.reset()})};if(n.prototype.use=function(t,e){if(!e&&!t.name)throw Error("Please provide a name for the service!");return t.vie=this,t.name=e?e:t.name,t.init&&t.init(),this.services[t.name]=t,this},n.prototype.service=function(t){if(!this.hasService(t))throw"Undefined service "+t;return this.services[t]},n.prototype.hasService=function(t){return this.services[t]?!0:!1},n.prototype.getServicesArray=function(){return r.map(this.services,function(t){return t})},n.prototype.load=function(t){return t||(t={}),t.vie=this,new this.Loadable(t)},n.prototype.save=function(t){return t||(t={}),t.vie=this,new this.Savable(t)},n.prototype.remove=function(t){return t||(t={}),t.vie=this,new this.Removable(t)},n.prototype.analyze=function(t){return t||(t={}),t.vie=this,new this.Analyzable(t)},n.prototype.find=function(t){return t||(t={}),t.vie=this,new this.Findable(t)},n.prototype.loadSchema=function(t,i){if(i=i?i:{},!t)throw Error("Please provide a proper URL");var r=this;return e.getJSON(t).success(function(t){try{n.Util.loadSchemaOrg(r,t,i.baseNS),i.success&&i.success.call(r)}catch(e){return i.error.call(r,e),void 0}}).error(function(e,n){i.error&&i.error.call(r,"Could not load schema from URL ("+t+"): "+n)}),this},n.prototype.getTypedEntityClass=function(t){var e=this.types.get(t);if(!e)throw Error("Unknown type "+t);return this.typeEntityClasses[t.id]||(this.typeEntityClasses[t.id]=this.Entity.extend({defaults:{"@type":t}})),this.typeEntityClasses[t.id]},n.prototype.typeEntityClasses={},"object"==typeof exports&&(exports.VIE=n,e||(e=require("jquery")),i||(i=require("backbone"),i.$=e),r||(r=require("underscore")._)),n.prototype.Able=function(){this.init=function(t,i){return this.options=t,this.services=t.from||t.using||t.to||[],this.vie=t.vie,this.methodName=i,this.deferred=e.Deferred(),this.resolve=this.deferred.resolve,this.resolveWith=this.deferred.resolveWith,this.reject=this.deferred.reject,this.rejectWith=this.deferred.rejectWith,this.success=this.done=this.deferred.done,this.fail=this.deferred.fail,this.then=this.deferred.then,this.always=this.deferred.always,this.from=this.using,this.to=this.using,this},this.using=function(t){var e=this;return t=r.isArray(t)?t:[t],r.each(t,function(t){var i="string"==typeof t?e.vie.service(t):t;e.services.push(i)}),this},this.execute=function(){var t=this;return r(this.services).each(function(e){e[t.methodName](t)}),this}},n.prototype.Loadable=function(t){this.init(t,"load")},n.prototype.Loadable.prototype=new n.prototype.Able,n.prototype.Savable=function(t){this.init(t,"save")},n.prototype.Savable.prototype=new n.prototype.Able,n.prototype.Removable=function(t){this.init(t,"remove")},n.prototype.Removable.prototype=new n.prototype.Able,n.prototype.Analyzable=function(t){this.init(t,"analyze")},n.prototype.Analyzable.prototype=new n.prototype.Able,n.prototype.Findable=function(t){this.init(t,"find")},n.prototype.Findable.prototype=new n.prototype.Able,n.Util={isReference:function(t){var e=RegExp("^\\<([^\\>]*)\\>$");return e.exec(t)?!0:!1},toReference:function(t,e){if(r.isArray(t))return r.map(t,function(t){return this.toReference(t)},this);if(!r.isString(t))return t;var i=t;return"_:"===t.substring(0,2)?i=t:e&&e.isCurie(t)?(i=e.uri(t),i==="<"+e.base()+t+">"&&(i="<"+t+">")):e&&!e.isUri(t)&&(i="<"+t+">"),i},fromReference:function(t,e){return e&&!e.isUri(t)?t:t.substring(1,t.length-1)},toCurie:function(t,e,i){if(n.Util.isCurie(t,i))return t;var r=":";for(var s in i.toObj())if(1===t.indexOf(i.get(s))){var o=RegExp("^<?"+i.get(s));return""===s&&(r=""),(e?"[":"")+t.replace(o,s+r).replace(/>$/,"")+(e?"]":"")}throw Error("No prefix found for URI '"+t+"'!")},isCurie:function(t,e){if(n.Util.isUri(t))return!1;try{return n.Util.toUri(t,e),!0}catch(i){return!1}},toUri:function(t,e){if(n.Util.isUri(t))return t;var i=":";for(var r in e.toObj())if(""!==r&&(0===t.indexOf(r+":")||0===t.indexOf("["+r+":"))){var s=RegExp("^\\[{0,1}"+r+i);return"<"+t.replace(s,e.get(r)).replace(/\]{0,1}$/,"")+">"}if(-1===t.indexOf(i))return"<"+e.base()+t+">";throw Error("No prefix found for CURIE '"+t+"'!")},isUri:function(t){return"string"==typeof t&&0===t.search(/^<.+>$/)},mapAttributeNS:function(t,e){var i=t;return e.isUri(t)||0===t.indexOf("@")||(e.isCurie(t)?i=e.uri(t):e.isUri(t)||(i=-1===t.indexOf(":")?"<"+e.base()+t+">":"<"+t+">")),i},rdf2Entities:function(t,i){if("function"!=typeof e.rdf)return n.Util._rdf2EntitiesNoRdfQuery(t,i);var s={};try{var o=i instanceof e.rdf?i.base(t.vie.namespaces.base()):e.rdf().base(t.vie.namespaces.base()).load(i,{});if(t.rules){var a=e.rdf.ruleset();for(var c in t.vie.namespaces.toObj())""!==c&&a.prefix(c,t.vie.namespaces.get(c));for(var u=0;t.rules.length>u;u++)if(t.rules.hasOwnProperty(u)){var p=t.rules[u];a.add(p.left,p.right)}o=o.reason(a,10)}o.where("?subject ?property ?object").each(function(){function e(t){if("string"==typeof t.value){if(t.lang){var e={toString:function(){return this["@value"]},"@value":t.value.replace(/^"|"$/g,""),"@language":t.lang};return e}return t.value}return"uri"===t.type?""+t:t.value}var i=""+this.subject;s[i]||(s[i]={"@subject":i,"@context":t.vie.namespaces.toObj(!0),"@type":[]});var r,n=""+this.property;try{r=t.vie.namespaces.curie(n)}catch(o){r=n}s[i][r]=s[i][r]||[],s[i][r].push(e(this.object))}),r(s).each(function(t){t["@type"]=t["@type"].concat(t["rdf:type"]),delete t["rdf:type"],r(t).each(function(e,i){1===e.length&&(t[i]=e[0])})})}catch(h){return[]}var l=[];return e.each(s,function(){try{var e=new t.vie.Entity(this);l.push(e)}catch(i){}}),l},getPreferredLangForPreferredProperty:function(t,e,i){var n,s,o;return s=[],r.each(i,function(i){r.each(e,function(e,a){n=null,"string"==typeof e&&t.get(e)?(n=r.flatten([t.get(e)]),r(n).each(function(t){var e,r,n,o,a;return o=n=a=0,e=t["@language"],"string"!=typeof t||t.indexOf("@")!==t.length-3&&t.indexOf("@")!==t.length-5||(e=t.replace(/(^\"*|\"*@)..(..)?$/g,"")),o+=e?e===i?a:20:10,r=""+t,r=r.replace(/(^\"*|\"*@..$)/g,""),s.push({score:o,value:r})})):"object"==typeof e&&t.get(e.property)&&(o=r.flatten([t.get(e.property)]),o=r(o).map(function(t){return t.isEntity?t.getSubject():t}),s.push({score:a,value:e.makeLabel(o)}))})}),s=r(s).sortBy(function(t){return t.score}),s.length?s[0].value:"n/a"},_rdf2EntitiesNoRdfQuery:function(t,e){var i=[];return r.forEach(e,function(t,e){var n={};n["@subject"]="<"+e+">",r.forEach(t,function(t,e){e="<"+e+">",r.forEach(t,function(t){return"uri"===t.type&&(t.value="<"+t.value+">"),n[e]&&!r.isArray(n[e])&&(n[e]=[n[e]]),r.isArray(n[e])?(n[e].push(t.value),void 0):(n[e]=t.value,void 0)})}),i.push(n)}),i},loadSchemaOrg:function(t,e,i){if(!e)throw Error("Please load the schema.json file.");t.types.remove("<http://schema.org/Thing>");var n=i?i:t.namespaces.base();t.namespaces.base(i);var s={DataType:"xsd:anyType",Boolean:"xsd:boolean",Date:"xsd:date",DateTime:"xsd:dateTime",Time:"xsd:time",Float:"xsd:float",Integer:"xsd:integer",Number:"xsd:anySimpleType",Text:"xsd:string",URL:"xsd:anyURI"},o=function(i,r){for(var n=t.types.add(r,[{id:"value",range:s[r]}]),a=0;i.length>a;a++){var c=t.types.get(i[a])?t.types.get(i[a]):o.call(t,e.datatypes[i[a]].supertypes,i[a]);n.inherit(c)}return n};for(var a in e.datatypes)if(!t.types.get(a)){var c=e.datatypes[a].supertypes;o.call(t,c,a)}var u=function(t){var e={};return t.label&&(e.label=t.label),t.url&&(e.url=t.url),t.comment&&(e.comment=t.comment),t.metadata&&(e=r.extend(e,t.metadata)),e},p=function(t){var i=[];return r.each(e.types[t].specific_properties,function(t){var r=e.properties[t];i.push({id:r.id,range:r.ranges,min:r.min,max:r.max,metadata:u(r)})}),i},h=function(i,r,n,s){for(var o=t.types.add(r,n,s),a=0;i.length>a;a++){var c=t.types.get(i[a])?t.types.get(i[a]):h.call(t,e.types[i[a]].supertypes,i[a],p.call(t,i[a]),u(e.types[i[a]]));o.inherit(c)}return"Thing"!==r||o.isof("owl:Thing")||o.inherit("owl:Thing"),o};r.each(e.types,function(e){if(!t.types.get(e.id)){var i=e.supertypes,r=u(e);h.call(t,i,e.id,p.call(t,e.id),r)}}),t.namespaces.base(n)},getEntityTypeUnion:function(t){var e=t.vie;return new e.Type("Union").inherit(t.get("@type"))},getFormSchemaForType:function(t,e){var i={};return r.each(t.attributes.toArray(),function(t){var e=n.Util.toCurie(t.id,!1,t.vie.namespaces);i[e]=n.Util.getFormSchemaForAttribute(t)}),r.each(i,function(t,r){t.type||delete i[r],"URL"===t.type&&(t.type="Text",t.dataType="url"),"List"!==t.type||t.listType||delete i[r],e||("NestedModel"===t.type||"NestedModel"===t.listType)&&delete i[r]}),i},getFormSchemaForAttribute:function(t){var e=t.range[0],i={},r=function(e){switch(e){case"xsd:anySimpleType":case"xsd:float":case"xsd:integer":return"Number";case"xsd:string":return"Text";case"xsd:date":return"Date";case"xsd:dateTime":return"DateTime";case"xsd:boolean":return"Checkbox";case"xsd:anyURI":return"URL";default:var i=t.vie.types.get(e);return i?i.attributes.get("value")?r(i.attributes.get("value").range[0]):"NestedModel":null}};return i.title=n.Util.toCurie(t.id,!1,t.vie.namespaces),t.min>0&&(i.validators=["required"]),t.max>1?(i.type="List",i.listType=r(e),"NestedModel"===i.listType&&(i.nestedModelType=e),i):(i.type=r(e),"NestedModel"===i.type&&(i.nestedModelType=e),i)},getFormSchema:function(t){if(!t||!t.isEntity)return{};var e=n.Util.getEntityTypeUnion(t),i=n.Util.getFormSchemaForType(e,!0);return r.each(i,function(e,r){("NestedModel"===e.type||"NestedModel"===e.listType)&&(i[r].model=t.vie.getTypedEntityClass(e.nestedModelType))}),i},xsdDateTime:function(t){function e(t){var e=""+t;return 2>e.length?"0"+e:e}var i=t.getFullYear(),r=e(t.getMonth()+1),n=e(t.getDate()),s=e(t.getHours()),o=e(t.getMinutes()),a=e(t.getSeconds());return i+"-"+r+"-"+n+"T"+s+":"+o+":"+a},extractLanguageString:function(t,e,i){var s,o,a,c,u;if(t&&"string"!=typeof t){for(e=r.isArray(e)?e:[e],i=r.isArray(i)?i:[i],s=0;e.length>s;s++)for(var p=0;i.length>p;p++){var h=i[p];if(o=e[s],t.has(o))for(a=t.get(o),a=r.isArray(a)?a:[a],c=0;a.length>c;c++)if(u=a[c],u=u.isEntity?n.Util.extractLanguageString(u,e,h):"string"==typeof u?u:"",u&&u.indexOf("@"+h)>-1)return u.replace(/"/g,"").replace(/@[a-z]+/,"").trim()}for(s=0;e.length>s;s++)if(o=e[s],t.has(o))for(a=t.get(o),a=r.isArray(a)?a:[a],c=0;a.length>c;c++)if(u=a[c],u.isEntity&&(u=n.Util.extractLanguageString(u,e,[])),u&&"string"==typeof u&&-1===u.indexOf("@"))return u.replace(/"/g,"").replace(/@[a-z]+/,"").trim()}return void 0},transformationRules:function(t){var i=[{left:["?subject a dbpedia:Person","?subject rdfs:label ?label"],right:function(t){return function(){return[e.rdf.triple(""+this.subject,"a","<"+t.base()+"Person>",{namespaces:t.toObj()}),e.rdf.triple(""+this.subject,"<"+t.base()+"name>",this.label,{namespaces:t.toObj()})]}}(t.vie.namespaces)},{left:["?subject a foaf:Person","?subject rdfs:label ?label"],right:function(t){return function(){return[e.rdf.triple(""+this.subject,"a","<"+t.base()+"Person>",{namespaces:t.toObj()}),e.rdf.triple(""+this.subject,"<"+t.base()+"name>",this.label,{namespaces:t.toObj()})]}}(t.vie.namespaces)},{left:["?subject a dbpedia:Place","?subject rdfs:label ?label"],right:function(t){return function(){return[e.rdf.triple(""+this.subject,"a","<"+t.base()+"Place>",{namespaces:t.toObj()}),e.rdf.triple(""+this.subject,"<"+t.base()+"name>",""+this.label,{namespaces:t.toObj()})]}}(t.vie.namespaces)},{left:["?subject a dbpedia:City","?subject rdfs:label ?label","?subject dbpedia:abstract ?abs","?subject dbpedia:country ?country"],right:function(t){return function(){return[e.rdf.triple(""+this.subject,"a","<"+t.base()+"City>",{namespaces:t.toObj()}),e.rdf.triple(""+this.subject,"<"+t.base()+"name>",""+this.label,{namespaces:t.toObj()}),e.rdf.triple(""+this.subject,"<"+t.base()+"description>",""+this.abs,{namespaces:t.toObj()}),e.rdf.triple(""+this.subject,"<"+t.base()+"containedIn>",""+this.country,{namespaces:t.toObj()})]}}(t.vie.namespaces)}];return i},getAdditionalRules:function(t){var i={Work:"CreativeWork",Film:"Movie",TelevisionEpisode:"TVEpisode",TelevisionShow:"TVSeries",Website:"WebPage",Painting:"Painting",Sculpture:"Sculpture",Event:"Event",SportsEvent:"SportsEvent",MusicFestival:"Festival",FilmFestival:"Festival",Place:"Place",Continent:"Continent",Country:"Country",City:"City",Airport:"Airport",Station:"TrainStation",Hospital:"GovernmentBuilding",Mountain:"Mountain",BodyOfWater:"BodyOfWater",Company:"Organization",Person:"Person"},n=[];return r.each(i,function(i,r){var s={left:["?subject a dbpedia:"+r,"?subject rdfs:label ?label"],right:function(t){return function(){return[e.rdf.triple(""+this.subject,"a","<"+t.base()+i+">",{namespaces:t.toObj()}),e.rdf.triple(""+this.subject,"<"+t.base()+"name>",""+this.label,{namespaces:t.toObj()})]}}(t.vie.namespaces)};n.push(s)}),n}},n.prototype.Entity=i.Model.extend({idAttribute:"@subject",isEntity:!0,defaults:{"@type":"owl:Thing"},initialize:function(t,e){return t||(t={}),e||(e={}),this.id=this["@subject"]=t["@subject"]?this.toReference(t["@subject"]):t["@subject"]=this.cid.replace("c","_:bnode"),this},schema:function(){return n.Util.getFormSchema(this)},get:function(t){t=n.Util.mapAttributeNS(t,this.vie.namespaces);var e=i.Model.prototype.get.call(this,t);return e=r.isArray(e)?e:[e],0===e.length?void 0:(e=r.map(e,function(e){return void 0!==e&&"@type"===t?(this.vie.types.get(e)||this.vie.types.add(e).inherit("owl:Thing"),this.vie.types.get(e)):void 0!==e&&this.vie.entities.get(e)?this.vie.entities.get(e):e},this),e=1===e.length?e[0]:e)},has:function(t){return t=n.Util.mapAttributeNS(t,this.vie.namespaces),i.Model.prototype.has.call(this,t)},hasRelations:function(){var t=!1;return r.each(this.attributes,function(e){e&&e.isCollection&&(t=!0)}),t},set:function(t,e,s){if(!t)return this;if(t["@subject"]&&(t["@subject"]=this.toReference(t["@subject"])),r.isString(t)){var o={};return o[t]=e,this.set(o,s)}e||(e={}),e.validate!==!1&&e.silent!==!0&&(e.validate=!0),t.attributes&&(t=t.attributes);var a;r.each(t,function(e,i){var r=n.Util.mapAttributeNS(i,this.vie.namespaces);i!==r&&(delete t[i],t[r]=e)},this),r.each(t,function(i,n){if(i&&-1===n.indexOf("@"))if(i.isCollection)i.each(function(t){this.vie.entities.addOrUpdate(t)},this);else if(i.isEntity)this.vie.entities.addOrUpdate(i),a=new this.vie.Collection(i,{vie:this.vie,predicate:n}),t[n]=a;else if(r.isArray(i)){if(this.attributes[n]&&this.attributes[n].isCollection){var s=this.attributes[n].addOrUpdate(i);t[n]=this.attributes[n],t[n].reset(s)}}else if(i["@value"]);else if(r.isObject(i)&&!r.isDate(i)){var o=new this.vie.Entity(i,e);this.vie.entities.addOrUpdate(o),a=new this.vie.Collection(i,{vie:this.vie,predicate:n}),t[n]=a}},this);var c=i.Model.prototype.set.call(this,t,e);return e&&e.ignoreChanges&&(this.changed={},this._previousAttributes=r.clone(this.attributes)),c},unset:function(t,e){return t=n.Util.mapAttributeNS(t,this.vie.namespaces),i.Model.prototype.unset.call(this,t,e)},validate:function(t,e){if(!e||e.validate!==!1){var i=this.get("@type");if(i){if(r.isArray(i)){var n=[];if(r.each(i,function(i){var r=this.validateByType(i,t,e);r&&n.push(r)},this),r.isEmpty(n))return;return r.flatten(n)}return this.validateByType(i,t,e)}}},validateByType:function(t,e){var i={max:"<%= property %> cannot contain more than <%= num %> items",min:"<%= property %> must contain at least <%= num %> items",required:"<%= property %> is required"};if(t.attributes){var n=function(t,e,n){return{property:t.id,constraint:e,message:r.template(i[e],r.extend({property:t.id},n))}},s=function(t,e){return!e[t.id]||r.isEmpty(e[t.id])?n(t,"required",{}):void 0},o=function(t,e){return e&&e[t.id]&&(e[t.id].isCollection||r.isArray(e[t.id]))?e[t.id].length>t.max?n(t,"max",{num:t.max}):void 0:void 0},a=[];if(r.each(t.attributes.list(),function(t){var i;t.max&&-1!=t.max&&(i=o(t,e),i&&a.push(i)),t.min&&t.min>0&&(i=s(t,e),i&&a.push(i))}),!r.isEmpty(a))return a}},isNew:function(){return"_:bnode"===this.getSubjectUri().substr(0,7)?!0:!1},hasChanged:function(t){return this.markedChanged?!0:i.Model.prototype.hasChanged.call(this,t)},forceChanged:function(t){this.markedChanged=t?!0:!1},getSubject:function(){return this.id===void 0&&(this.id=this.attributes[this.idAttribute]),"string"==typeof this.id?"http://"===this.id.substr(0,7)||"urn:"===this.id.substr(0,4)?this.toReference(this.id):this.id:this.cid.replace("c","_:bnode")},getSubjectUri:function(){return this.fromReference(this.getSubject())},isReference:function(t){return n.Util.isReference(t)},toReference:function(t){return n.Util.toReference(t,this.vie.namespaces)},fromReference:function(t){return n.Util.fromReference(t,this.vie.namespaces)},as:function(t){if("JSON"===t)return this.toJSON();if("JSONLD"===t)return this.toJSONLD();throw Error("Unknown encoding "+t)},toJSONLD:function(){var t={};return r.each(this.attributes,function(e,i){var r=this.get(i);e instanceof this.vie.Collection&&(r=e.map(function(t){return t.getSubject()})),r instanceof this.vie.Type&&(r=""+r),t[i]=r},this),t["@subject"]=this.getSubject(),t},setOrAdd:function(t,e,i){return r.isString(t)&&e?this._setOrAddOne(t,e,i):r.isObject(t)&&r.each(t,function(t,i){this._setOrAddOne(i,t,e)},this),this},_setOrAddOne:function(t,e,s){if(t&&e){if(s=s?s:{},t=n.Util.mapAttributeNS(t,this.vie.namespaces),r.isArray(e))return r.each(e,function(i){this._setOrAddOne(t,e[i],s)},this),void 0;"@type"===t&&e instanceof this.vie.Type&&(e=e.id);var o={},a=i.Model.prototype.get.call(this,t);if(a)if(a.isCollection){if(e.isCollection)e.each(function(t){a.add(t)});else if(e.isEntity)a.add(e);else{if(!r.isObject(e))throw Error("you cannot add a literal to a collection of entities!");e=new this.vie.Entity(e),a.add(e)}this.trigger("change:"+t,this,e,{})}else{if(!r.isArray(a)){var c=[a];return c.push(e),o[t]=c,this.set(o,s)}if(e.isCollection)e.each(function(i){this._setOrAddOne(t,e.at(i).getSubject(),s)},this);else if(e.isEntity)this._setOrAddOne(t,e.getSubject(),s);else if(r.isObject(e))e=new this.vie.Entity(e),this._setOrAddOne(t,e,s);else{var u=a.slice(0);u.push(e),this.set(t,u)}}else o[t]=e,this.set(o,s)}},hasType:function(t){return t=this.vie.types.get(t),this.hasPropertyValue("@type",t)},hasPropertyValue:function(t,e){var i=this.get(t);return r.isObject(e)||(e=this.vie.entities.get(e)),r.isArray(i)?-1!==i.indexOf(e):i===e},isof:function(t){var e=this.get("@type");if(void 0===e)return!1;e=r.isArray(e)?e:[e],t=this.vie.types.get(t)?this.vie.types.get(t):new this.vie.Type(t);var i=!1;return r.each(e,function(e){this.vie.types.get(e).isof(t)&&(i=!0)},this),i},addTo:function(t,e){if(t instanceof this.vie.Collection)return e?t.addOrUpdate(this):t.add(this),this;throw Error("Please provide a proper collection of type VIE.Collection as argument!")}}),n.prototype.Collection=i.Collection.extend({model:n.prototype.Entity,initialize:function(t,e){if(!e||!e.vie)throw Error("Each collection needs a VIE reference");this.vie=e.vie,this.predicate=e.predicate},canAdd:function(){return!0},get:function(t){return null===t?null:(t=t.getSubject?t.getSubject():t,"string"==typeof t&&0===t.indexOf("_:")?2===t.indexOf("bnode")?(t=t.replace("_:bnode","c"),this._byId[t]):this._byId["<"+t+">"]:this._byId[t]?this._byId[t]:(t=this.toReference(t),this._byId[t]))},addOrUpdate:function(t,i){i=i||{};var n,s=this;if(r.isArray(t)){var o=[];return r.each(t,function(t){o.push(s.addOrUpdate(t,i))}),o}if(void 0===t)throw Error("No model given");if(r.isString(t)&&(t={"@subject":t,id:t}),t.isEntity||(t=new this.model(t)),t.id&&this.get(t.id)&&(n=this.get(t.id)),this.get(t.cid)&&(n=this.get(t.cid)),n){var a={};return r.each(t.attributes,function(o,c){if(!n.has(c))return a[c]=o,!0;if("@subject"===c&&t.isNew()&&!n.isNew())return!0;if(n.get(c)===o)return!0;var u=n.attributes[c],p=o;return u instanceof s.vie.Collection?!0:i.overrideAttributes?(a[c]=o,!0):("@context"===c?a[c]=e.extend(!0,{},u,p):(u=e.isArray(u)?u:[u],p=e.isArray(p)?p:[p],a[c]=r.uniq(u.concat(p)),a[c]=1===a[c].length?a[c][0]:a[c]),void 0)}),r.isEmpty(a)||n.set(a,i.updateOptions),n}return this.add(t,i.addOptions),t},isReference:function(t){return n.Util.isReference(t)},toReference:function(t){return n.Util.toReference(t,this.vie.namespaces)},fromReference:function(t){return n.Util.fromReference(t,this.vie.namespaces)},isCollection:!0}),n.prototype.Type=function(t,i,r){if(void 0===t||"string"!=typeof t)throw"The type constructor needs an 'id' of type string! E.g., 'Person'";if(this.id=this.vie.namespaces.isUri(t)?t:this.vie.namespaces.uri(t),this.vie.types.get(this.id))throw Error("The type "+this.id+" is already defined!");this.supertypes=new this.vie.Types,this.subtypes=new this.vie.Types,this.attributes=new this.vie.Attributes(this,i?i:[]),this.metadata=r?r:{},this.isof=function(t){if(t=this.vie.types.get(t))return t.subsumes(this.id);throw Error("No valid type given")},this.subsumes=function(t){if(t=this.vie.types.get(t)){if(this.id===t.id)return!0;for(var e=this.subtypes.list(),i=0;e.length>i;i++){var r=e[i];if(r&&(r.id===t.id||r.subsumes(t)))return!0}return!1}throw Error("No valid type given")},this.inherit=function(t){if("string"==typeof t)this.inherit(this.vie.types.get(t));else if(t instanceof this.vie.Type){t.subtypes.addOrOverwrite(this),this.supertypes.addOrOverwrite(t);try{this.attributes.list()}catch(i){throw t.subtypes.remove(this),this.supertypes.remove(t),i}}else{if(!e.isArray(t))throw Error("Wrong argument in VIE.Type.inherit()");for(var r=0,n=t.length;n>r;r++)this.inherit(t[r])}return this},this.hierarchy=function(){for(var t={id:this.id,subtypes:[]},e=this.subtypes.list(),i=0,r=e.length;r>i;i++){var n=this.vie.types.get(e[i]);t.subtypes.push(n.hierarchy())}return t},this.instance=function(t,e){var i=this.vie.getTypedEntityClass(this);return new i(t,e)},this.toString=function(){return this.id}},n.prototype.Types=function(){this._types={},this.add=function(t,e,i){if(r.isArray(t))return r.each(t,function(t){this.add(t)},this),this;if(this.get(t))throw Error("Type '"+t+"' already registered.");if("string"==typeof t){var n=new this.vie.Type(t,e,i);return this._types[n.id]=n,n}if(t instanceof this.vie.Type)return this._types[t.id]=t,t;throw Error("Wrong argument to VIE.Types.add()!")},this.addOrOverwrite=function(t,e){return this.get(t)&&this.remove(t),this.add(t,e)},this.get=function(t){if(!t)return void 0;if("string"==typeof t){var e=this.vie.namespaces.isUri(t)?t:this.vie.namespaces.uri(t);return this._types[e]}return t instanceof this.vie.Type?this.get(t.id):void 0},this.remove=function(t){var e=this.get(t);if(!e)return this;if(!e||e.subsumes("owl:Thing"))return this;delete this._types[e.id];for(var i=e.subtypes.list(),r=0;i.length>r;r++){var n=i[r];1===n.supertypes.list().length?this.remove(n):n.supertypes.remove(e.id)}return e},this.toArray=this.list=function(){var t=[];for(var e in this._types)t.push(this._types[e]);return t},this.sort=function(t,i){var r=this;if(t=e.isArray(t)?t:[t],i=i?!0:!1,0===t.length)return[];var n,s,o=[t[0]];for(n=1,s=t.length;s>n;n++){var a=t[n],c=r.get(a);if(c)for(var u=0;o.length>u;u++){if(c.subsumes(o[u])){o.splice(u,0,a);break}u===o.length-1&&o.push(a)}}for(n=0;o.length>n;n++)o.lastIndexOf(o[n])!==n&&(o.splice(n,1),n--);return i||o.reverse(),o}},n.prototype.Attribute=function(t,e,i,n,s,o){if(void 0===t||"string"!=typeof t)throw Error("The attribute constructor needs an 'id' of type string! E.g., 'Person'");if(void 0===e)throw Error("The attribute constructor of "+t+" needs 'range'.");if(void 0===i)throw Error("The attribute constructor of "+t+" needs a 'domain'.");this._domain=i,this.id=this.vie.namespaces.isUri(t)?t:this.vie.namespaces.uri(t),this.range=r.isArray(e)?e:[e],n=n?n:0,this.min=n>0?n:0,s=s?s:1,-1===s&&(s=Number.MAX_VALUE),this.max=s>=this.min?s:this.min,this.metadata=o?o:{},this.applies=function(t){this.vie.types.get(t)&&(t=this.vie.types.get(t));for(var e=0,i=this.range.length;i>e;e++){var r=this.vie.types.get(this.range[e]);if(void 0===r&&"string"==typeof t){if(t===this.range[e])return!0}else if(t.isof(this.range[e]))return!0}return!1}},n.prototype.Attributes=function(t,i){this._local={},this._attributes={},this.domain=t,this.add=function(t,e,i,n,s){if(r.isArray(t))return r.each(t,function(t){this.add(t)},this),this;if(this.get(t))throw Error("Attribute '"+t+"' already registered for domain "+this.domain.id+"!");if("string"==typeof t){var o=new this.vie.Attribute(t,e,this.domain,i,n,s);return this._local[o.id]=o,o}if(t instanceof this.vie.Attribute)return t.domain=this.domain,t.vie=this.vie,this._local[t.id]=t,t;throw Error("Wrong argument to VIE.Types.add()!")},this.remove=function(t){var e=this.get(t);if(e.id in this._local)return delete this._local[e.id],e;throw Error("The attribute "+t+" is inherited and cannot be removed from the domain "+this.domain.id+"!")},this.get=function(t){if("string"==typeof t){var e=this.vie.namespaces.isUri(t)?t:this.vie.namespaces.uri(t);return this._inherit()._attributes[e]}if(t instanceof this.vie.Attribute)return this.get(t.id);throw Error("Wrong argument in VIE.Attributes.get()")},this._inherit=function(){var t,i,n,s,o,a=e.extend(!0,{},this._local),c=r.map(this.domain.supertypes.list(),function(t){return t.attributes}),u={},p={};for(t=0,s=c.length;s>t;t++){var h=c[t].list();for(i=0,o=h.length;o>i;i++)n=h[i].id,n in a||(n in u||n in p?(p[n]||(p[n]={range:[],mins:[],maxs:[],metadatas:[]}),n in u&&(p[n].range=e.merge(p[n].range,u[n].range),p[n].mins=e.merge(p[n].mins,[u[n].min]),p[n].maxs=e.merge(p[n].maxs,[u[n].max]),p[n].metadatas=e.merge(p[n].metadatas,[u[n].metadata]),delete u[n]),p[n].range=e.merge(p[n].range,h[i].range),p[n].mins=e.merge(p[n].mins,[h[i].min]),p[n].maxs=e.merge(p[n].maxs,[h[i].max]),p[n].metadatas=e.merge(p[n].metadatas,[h[i].metadata]),p[n].range=r.uniq(p[n].range),p[n].mins=r.uniq(p[n].mins),p[n].maxs=r.uniq(p[n].maxs),p[n].metadatas=r.uniq(p[n].metadatas)):u[n]=h[i])}e.extend(a,u);for(n in p){for(var l=p[n].range,d=p[n].mins,f=p[n].maxs,v=p[n].metadatas,m=[],y=0,g=l.length;g>y;y++){var b=this.vie.types.get(l[y]),w=!1;if(b)for(i=0;g>i;i++)if(i!==y){var x=this.vie.types.get(l[i]);if(x&&x.isof(b)){w=!0;break}}w||m.push(l[y])}var j=r.max(d),E=r.min(f);if(!(E>=j&&E>=0&&j>=0))throw Error("This inheritance is not allowed because of an invalid minCount/maxCount pair!");a[n]=new this.vie.Attribute(n,m,this,j,E,v[0])}return this._attributes=a,this},this.toArray=this.list=function(t){var e=[],i=this._inherit()._attributes;for(var r in i)(!t||i[r].applies(t))&&e.push(i[r]);return e},i=r.isArray(i)?i:[i],r.each(i,function(t){this.add(t.id,t.range,t.min,t.max,t.metadata)},this)},n.prototype.Namespaces)throw Error("ERROR: VIE.Namespaces is already defined. Please check your VIE installation!");n.prototype.Namespaces=function(t,e){if(!t)throw Error("Please provide a base namespace!");if(this._base=t,this._namespaces=e?e:{},"object"!=typeof this._namespaces||r.isArray(this._namespaces))throw Error("If you want to initialise VIE namespace prefixes, please provide a proper object!")},n.prototype.Namespaces.prototype.base=function(t){if(t){if("string"==typeof t)return this.removeNamespace(t),this._base=t,this._base;throw Error("Please provide a valid namespace!")}return this._base},n.prototype.Namespaces.prototype.add=function(t,i){if("object"==typeof t){for(var r in t)this.add(r,t[r]);return this}if(""===t)return this.base(i),this;if(this.contains(t)&&i!==this._namespaces[t])throw Error("ERROR: Trying to register namespace prefix mapping ("+t+","+i+")!"+"There is already a mapping existing: '("+t+","+this.get(t)+")'!");return e.each(this._namespaces,function(e,r){if(r===i&&e!==t)throw Error("ERROR: Trying to register namespace prefix mapping ("+t+","+i+")!"+"There is already a mapping existing: '("+e+","+i+")'!")}),this._namespaces[t]=i,this},n.prototype.Namespaces.prototype.addOrReplace=function(t,e){if("object"==typeof t){for(var i in t)this.addOrReplace(i,t[i]);return this}return this.remove(t),this.removeNamespace(e),this.add(t,e)},n.prototype.Namespaces.prototype.get=function(t){return""===t?this.base():this._namespaces[t]},n.prototype.Namespaces.prototype.getPrefix=function(t){var i;return 0===t.indexOf("<")&&(t=t.substring(1,t.length-1)),e.each(this._namespaces,function(e,r){0===t.indexOf(r)&&(i=e),0===t.indexOf(e+":")&&(i=e)}),i},n.prototype.Namespaces.prototype.contains=function(t){return t in this._namespaces},n.prototype.Namespaces.prototype.containsNamespace=function(t){return void 0!==this.getPrefix(t)},n.prototype.Namespaces.prototype.update=function(t,e){return this.remove(t),this.add(t,e)},n.prototype.Namespaces.prototype.updateNamespace=function(t,e){return this.removeNamespace(t),this.add(t,e)},n.prototype.Namespaces.prototype.remove=function(t){return t&&delete this._namespaces[t],this},n.prototype.Namespaces.prototype.removeNamespace=function(t){var e=this.getPrefix(t);return e&&delete this._namespaces[e],this},n.prototype.Namespaces.prototype.toObj=function(t){return t?e.extend({},this._namespaces):e.extend({"":this._base},this._namespaces)},n.prototype.Namespaces.prototype.curie=function(t,e){return n.Util.toCurie(t,e,this)},n.prototype.Namespaces.prototype.isCurie=function(t){return n.Util.isCurie(t,this)},n.prototype.Namespaces.prototype.uri=function(t){return n.Util.toUri(t,this)},n.prototype.Namespaces.prototype.isUri=n.Util.isUri,n.prototype.ClassicRDFa=function(t){this.vie=t},n.prototype.ClassicRDFa.prototype={readEntities:function(t){var e=[],i=this.vie.RDFaEntities.getInstances(t);return r.each(i,function(t){e.push(t.toJSONLD())}),e},findPredicateElements:function(t,e,i){return this.vie.services.rdfa.findPredicateElements(t,e,i)},getPredicate:function(t){return this.vie.services.rdfa.getElementPredicate(t)},getSubject:function(t){return this.vie.services.rdfa.getElementSubject(t)}},n.prototype.ClassicRDFaEntities=function(t){this.vie=t},n.prototype.ClassicRDFaEntities.prototype={getInstances:function(t){this.vie.services.rdfa||this.vie.use(new this.vie.RdfaService);var e=null,i=!1;for(this.vie.load({element:t}).from("rdfa").execute().done(function(t){e=t,i=!0});!i;);return e},getInstance:function(t){var e=this.getInstances(t);return e&&e.length?e.pop():null}},n.prototype.ClassicEntityManager=function(t){this.vie=t,this.entities=this.vie.entities},n.prototype.ClassicEntityManager.prototype={getBySubject:function(t){return this.vie.entities.get(t)},getByJSONLD:function(t){if("string"==typeof t)try{t=e.parseJSON(t)}catch(i){return null}return this.vie.entities.addOrUpdate(t)},initializeCollection:function(){}},function(){n.prototype.DBPediaService=function(t){var i={name:"dbpedia",namespaces:{owl:"http://www.w3.org/2002/07/owl#",yago:"http://dbpedia.org/class/yago/",foaf:"http://xmlns.com/foaf/0.1/",georss:"http://www.georss.org/georss/",geo:"http://www.w3.org/2003/01/geo/wgs84_pos#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",dbpedia:"http://dbpedia.org/ontology/",dbprop:"http://dbpedia.org/property/",dcelements:"http://purl.org/dc/elements/1.1/"},rules:[]};
this.options=e.extend(!0,i,t?t:{}),this.vie=null,this.name=this.options.name,e.ajaxSetup({converters:{"text application/rdf+json":function(t){return JSON.parse(t)}},timeout:6e4})},n.prototype.DBPediaService.prototype={init:function(){for(var t in this.options.namespaces){var i=this.options.namespaces[t];this.vie.namespaces.add(t,i)}return this.rules=e.extend([],n.Util.transformationRules(this)),this.rules=e.merge(this.rules,this.options.rules?this.options.rules:[]),this.connector=new this.vie.DBPediaConnector(this.options),this},load:function(t){var e=this,i=t instanceof this.vie.Loadable;if(!i)throw Error("Invalid Loadable passed");var s=function(i){i="string"==typeof i?JSON.parse(i):i,r.defer(function(){try{var s=n.Util.rdf2Entities(e,i);s=r.isArray(s)?s:[s],r.each(s,function(t){t.set("DBPediaServiceLoad",n.Util.xsdDateTime(new Date))}),s=1===s.length?s[0]:s,t.resolve(s)}catch(o){t.reject(o)}})},o=function(e){t.reject(e)},a=t.options.entity?t.options.entity:t.options.entities;if(a){a=r.isArray(a)?a:[a];for(var c=[],u=0;a.length>u;u++){var p="string"==typeof a[u]?a[u]:a[u].id;c.push(p)}this.connector.load(c,s,o)}else t.reject([]);return this}},n.prototype.DBPediaConnector=function(t){this.options=t,this.baseUrl="http://dbpedia.org/sparql?default-graph-uri=http%3A%2F%2Fdbpedia.org&timeout=0"},n.prototype.DBPediaConnector.prototype={load:function(t,i,n,s){s||(s={});var o=this.baseUrl+"&format="+encodeURIComponent("application/rdf+json")+"&query=";if(r.isArray(t)){for(var a="",c="",u=0;t.length>u;u++){var p=/^<.+>$/.test(t[u])?t[u]:"<"+t[u]+">";u>0&&(a+=" .",c+=" UNION "),a+=" "+p+" ?prop"+u+" ?val"+u,c+=" { "+p+" ?prop"+u+" ?val"+u+" }"}o+=encodeURIComponent("CONSTRUCT {"+a+" } WHERE {"+c+" }")}else t=/^<.+>$/.test(t)?t:"<"+t+">",o+=encodeURIComponent("CONSTRUCT { "+t+" ?prop ?val } WHERE { "+t+" ?prop ?val }");var h=s.format||"application/rdf+json";return"undefined"!=typeof exports&&"undefined"!=typeof process?this._loadNode(o,i,n,s,h):(e.ajax({success:function(t){i(t)},error:n,type:"GET",url:o,accepts:{"application/rdf+json":"application/rdf+json"}}),this)},_loadNode:function(t,e,i,r,n){var s=require("request"),o=s({method:"GET",uri:t,headers:{Accept:n}},function(t,r,n){return 200!==r.statusCode?i(n):(e(JSON.parse(n)),void 0)});return o.end(),this}}}(),function(){n.prototype.OpenCalaisService=function(t){var i={name:"opencalais",url:["http://api.opencalais.com/enlighten/rest/"],timeout:6e4,namespaces:{opencalaisc:"http://s.opencalais.com/1/pred/",opencalaiscr:"http://s.opencalais.com/1/type/er/",opencalaiscm:"http://s.opencalais.com/1/type/em/e/"},rules:[]};this.options=e.extend(!0,i,t?t:{}),this.vie=null,this.name=this.options.name,e.ajaxSetup({converters:{"text application/rdf+json":function(t){return JSON.parse(t)}},timeout:this.options.timeout})},n.prototype.OpenCalaisService.prototype={init:function(){for(var t in this.options.namespaces){var i=this.options.namespaces[t];this.vie.namespaces.add(t,i)}this.rules=e.extend([],n.Util.transformationRules(this)),this.rules=e.merge(this.rules,this.options.rules?this.options.rules:[]),this.connector=new this.vie.OpenCalaisConnector(this.options)},analyze:function(t){var i=this,s=t instanceof this.vie.Analyzable;if(!s)throw"Invalid Analyzable passed";var o=t.options.element?t.options.element:e("body"),a=i._extractText(o);if(a.length>0){var c=function(e){r.defer(function(){var r=n.Util.rdf2Entities(i,e);t.resolve(r)})},u=function(e){t.reject(e)};this.connector.analyze(a,c,u)}else console.warn("No text found in element."),t.resolve([])},_extractText:function(t){if(t.get(0)&&t.get(0).tagName&&("TEXTAREA"==t.get(0).tagName||"INPUT"==t.get(0).tagName&&t.attr("type","text")))return t.get(0).val();var i=t.text().replace(/\s+/g," ").replace(/\0\b\n\r\f\t/g,"");return e.trim(i)}},n.prototype.OpenCalaisConnector=function(t){this.options=t,this.baseUrl=r.isArray(t.url)?t.url:[t.url],this.enhancerUrlPrefix="/"},n.prototype.OpenCalaisConnector.prototype={analyze:function(t,i,n,s){if(s||(s={urlIndex:0}),s.urlIndex>=this.baseUrl.length)return n("Could not connect to the given OpenCalais endpoints! Please check for their setup!"),void 0;var o=this.baseUrl[s.urlIndex].replace(/\/$/,"");o+=this.enhancerUrlPrefix;var a=s.format||"application/rdf+json",c=function(t,e,i,n,s){return function(){console.error("OpenCalais connection error",arguments),t.analyze(e,i,n,r.extend(s,{urlIndex:s.urlIndex+1}))}}(this,t,i,n,s),u=this._prepareData(t);return"undefined"!=typeof exports&&"undefined"!=typeof process?this._analyzeNode(o,u,i,c,s,a):(e.ajax({success:function(t,e,r){var n=r.responseText.replace(/<!--[\s\S]*?-->/g,"");i(n)},error:c,type:"POST",url:o,data:u,accept:"text/plain"}),void 0)},_analyzeNode:function(t,e,i,r,n,s){var o=require("request"),a=o({method:"POST",uri:t,body:e,headers:{Accept:s}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});a.end()},_prepareData:function(t){return{licenseID:this.options.api_key,calculareRelevanceScore:"true",enableMetadataType:"GenericRelations,SocialTags",contentType:"text/html",content:t}}}}(),function(){n.prototype.RdfaRdfQueryService=function(t){var i={name:"rdfardfquery",namespaces:{},rules:[]};this.options=e.extend(!0,i,t?t:{}),this.views=[],this.vie=null,this.name=this.options.name},n.prototype.RdfaRdfQueryService.prototype={init:function(){for(var t in this.options.namespaces){var i=this.options.namespaces[t];this.vie.namespaces.add(t,i)}this.rules=e.extend([],n.Util.transformationRules(this)),this.rules=e.merge(this.rules,this.options.rules?this.options.rules:[])},analyze:function(t){return this.load(t)},load:function(t){var i=this,r=t instanceof this.vie.Loadable||t instanceof this.vie.Analyzable;if(!r)throw Error("Invalid Loadable/Analyzable passed");var s=t.options.element?t.options.element:e(document);try{var o=e(s).find("[about],[typeof]").rdfa();e.each(e(s).xmlns(),function(t,e){i.vie.namespaces.addOrReplace(t,""+e)});var a=n.Util.rdf2Entities(this,o);t.resolve(a)}catch(c){t.reject(c)}},save:function(t){var i=t instanceof this.vie.Savable;i||t.reject("Invalid Savable passed"),t.options.element||t.reject("Unable to write entity to RDFa, no element given"),t.options.entity||t.reject("Unable to write to RDFa, no entity given"),e.rdf||t.reject("No rdfQuery found.");var r=t.options.entity,n=[],s=r.get("@type");s=e.isArray(s)?s[0]:s,s=s.id,n.push(r.getSubject()+" a "+s),e(t.options.element).rdfa(n),t.resolve()}}}(),function(){n.prototype.RdfaService=function(t){var i={name:"rdfa",namespaces:{},subjectSelector:"[about],[typeof],[src],html",predicateSelector:"[property],[rel]",rules:[],bnodePrefix:"_a"};this.options=e.extend(!0,i,t?t:{}),this.bnodes=0,this.views=[],this.templates={},this.datatypeReaders={"<http://www.w3.org/2001/XMLSchema#boolean>":function(t){return"true"===t||1===t||t===!0?!0:!1},"<http://www.w3.org/2001/XMLSchema#dateTime>":function(t){return new Date(t)},"<http://www.w3.org/2001/XMLSchema#integer>":function(t){return parseInt(t,10)}},this.datatypeWriters={"<http://www.w3.org/2001/XMLSchema#dateTime>":function(t){return r.isDate(t)?t.toISOString():t}},this.vie=null,this.name=this.options.name},n.prototype.RdfaService.prototype={init:function(){for(var t in this.options.namespaces){var i=this.options.namespaces[t];this.vie.namespaces.add(t,i)}this.rules=e.merge([],n.Util.transformationRules(this)),this.rules=e.merge(this.rules,this.options.rules?this.options.rules:[])},analyze:function(t){return this.load(t)},load:function(t){var i=t instanceof this.vie.Loadable||t instanceof this.vie.Analyzable;if(!i)throw Error("Invalid Loadable/Analyzable passed");var r;if(t.options.element)r=t.options.element;else{if("undefined"==typeof document)return t.resolve([]);r=e(document)}var n=this.readEntities(r);t.resolve(n)},save:function(t){var e=t instanceof this.vie.Savable;if(!e)throw"Invalid Savable passed";if(!t.options.element)throw"Unable to write entity to RDFa, no element given";if(!t.options.entity)throw"Unable to write to RDFa, no entity given";this._writeEntity(t.options.entity,t.options.element),t.resolve()},readEntities:function(t){var i=this,r=this.xmlns(t);for(var n in r)this.vie.namespaces.addOrReplace(n,r[n]);var s=[];return e(this.options.subjectSelector,t).add(e(t).filter(this.options.subjectSelector)).each(function(){var t=i._readEntity(e(this));t&&s.push(t)}),s},_readEntity:function(t){var i=this.getElementSubject(t),n=this._getElementType(t),s=this._readEntityPredicates(i,t,!1);if(e.isEmptyObject(s))return null;var o=this.vie;r.each(s,function(t,e){if(r.isArray(t)){var i=new this.vie.Collection([],{vie:o,predicate:e});r.each(t,function(t){var e=o.entities.addOrUpdate({"@subject":t});i.addOrUpdate(e)}),s[e]=i}},this),s["@subject"]=i,n&&(s["@type"]=n);var a=new this.vie.Entity(s);return a=this.vie.entities.addOrUpdate(a,{updateOptions:{silent:!0,ignoreChanges:!0}}),this._registerEntityView(a,t),a},_writeEntity:function(t,i){var r=this;return this.findPredicateElements(this.getElementSubject(i),i,!0).each(function(){var i=e(this),n=r.getElementPredicate(i);if(!t.has(n))return!0;var s=t.get(n);return s&&s.isCollection?!0:s===r.readElementValue(n,i)?!0:(r.writeElementValue(n,i,s),void 0)}),!0},_getViewForElement:function(t,i){var r;return e.each(this.views,function(){return e(this.el).get(0)===t.get(0)?i&&!this.template?!0:(r=this,!1):void 0}),r},_registerEntityView:function(t,i,r){if(i.length){var n=this,s=this._getViewForElement(i);return s?(t.hasRelations()&&!s.collectionsChecked&&this._registerEntityCollectionViews(t,i,s),s):(s=new this.vie.view.Entity({model:t,el:i,tagName:i.get(0).nodeName,vie:this.vie,service:this.name}),this.views.push(s),r&&e(i).find(this.options.predicateSelector).add(e(i).filter(this.options.predicateSelector)).each(function(){var i=e(this).attr("rel");i&&t.set(i,new n.vie.Collection([],{vie:n.vie,predicate:i}))}),this._registerEntityCollectionViews(t,i,s),s)}},_registerEntityCollectionViews:function(t,i,n){var s=this;r.each(t.attributes,function(r,o){var a=t.fromReference(t.get(o));a&&a.isCollection&&(e.each(s.getElementByPredicate(o,i),function(){s._registerCollectionView(a,e(this),t)}),n.collectionsChecked=!0)})},setTemplate:function(t,e,i){var n;i||(i=e,e="default"),t=this.vie.namespaces.isUri(t)?t:this.vie.namespaces.uri(t),n=r.isFunction(i)?i:this.getElementTemplate(i),this.templates[t]||(this.templates[t]={}),this.templates[t][e]=n,r.each(this.views,function(i){i instanceof this.vie.view.Collection&&i.collection.predicate===e&&(i.templates[t]=n)},this)},getTemplate:function(t,e){return e||(e="default"),t=this.vie.namespaces.isUri(t)?t:this.vie.namespaces.uri(t),this.templates[t]?this.templates[t][e]:void 0},_getElementTemplates:function(t,i,n){var s={},o=i.get("@type");if(o&&o.attributes&&o.attributes.get(n)){var a=o.attributes.get(n);if(r.each(a.range,function(t){var e=this.getTemplate(t,n);if(e){var i=this.vie.types.get(t);s[i.id]=e}},this),!r.isEmpty(s))return s}var c=this;if(e("[typeof]",t).each(function(){var t=e(this),i=t.attr("typeof");if(i=c.vie.namespaces.isUri(i)?i:c.vie.namespaces.uri(i),!s[i]){var r=c.getElementTemplate(t);s[i]=r,s["<http://www.w3.org/2002/07/owl#Thing>"]=r}}),r.isEmpty(s)){var u=t.children(":first-child");u.length&&(s["<http://www.w3.org/2002/07/owl#Thing>"]=c.getElementTemplate(u))}return s},getElementTemplate:function(t){r.isString(t)&&(t=e.trim(t));var i=this;return function(r,n){var s=e(t).clone(!1);void 0!==s.attr("about")&&s.attr("about",""),s.find("[about]").attr("about","");var o=i.findPredicateElements(o,s,!1).each(function(){var t=e(this),n=i.getElementPredicate(t);return r.has(n)&&r.get(n).isCollection?!0:(i.writeElementValue(null,t,""),void 0)});n(s)}},_registerCollectionView:function(t,e,i){var r=this._getViewForElement(e,!0);return r?r:(r=new this.vie.view.Collection({owner:i,collection:t,model:t.model,el:e,templates:this._getElementTemplates(e,i,t.predicate),service:this}),this.views.push(r),r)},_getElementType:function(t){var i;return e(t).attr("typeof")!==this.options.attributeExistenceComparator?(i=e(t).attr("typeof"),i&&-1!==i.indexOf("://")?"<"+i+">":i):null},_generatebnodeId:function(){var t=this.options.bnodePrefix+":"+this.bnodes;return this.bnodes++,t},getElementSubject:function(t){var i=this;if("undefined"!=typeof document&&t===document)return document.baseURI;var r,n=null;return e(t).closest(this.options.subjectSelector).each(function(){if(n=this,e(this).attr("about")!==i.options.attributeExistenceComparator)return r=e(this).attr("about"),!0;if(e(this).attr("src")!==i.options.attributeExistenceComparator)return r=e(this).attr("src"),!0;if(e(this).attr("typeof")!==i.options.attributeExistenceComparator){var t=e(this);return t.data("vie-bnode")?(r=t.data("vie-bnode"),!0):(r=i._generatebnodeId(),t.data("vie-bnode",r),!0)}"HTML"===e(this).get(0).nodeName&&e("base",this).each(function(){r=e(this).attr("href")})}),r?"object"==typeof r?r:0===r.indexOf("_:")?r:0===r.indexOf("<")?r:"<"+r+">":void 0},setElementSubject:function(t,i){return e(i).attr("src")?e(i).attr("src",t):e(i).attr("about",t)},getElementPredicate:function(t){var i;return t=e(t),i=t.attr("property"),i||(i=t.attr("rel")),i},getElementBySubject:function(t,i){var r=this;return e(i).find(this.options.subjectSelector).add(e(i).filter(this.options.subjectSelector)).filter(function(){return r.getElementSubject(e(this))!==t?!1:!0})},getElementByPredicate:function(t,i){var r=this,n=this.getElementSubject(i);return e(i).find(this.options.predicateSelector).add(e(i).filter(this.options.predicateSelector)).filter(function(){var i=r.getElementPredicate(e(this));return r.vie.namespaces.curie(i)!==r.vie.namespaces.curie(t)?!1:r.getElementSubject(this)!==n?!1:!0})},_readEntityPredicates:function(t,i,r){var n=this,s={};return this.findPredicateElements(t,i,!0).each(function(){var t=e(this),i=n.getElementPredicate(t);if(""!==i){var o=n.readElementValue(i,t);(null!==o||r)&&(s[i]=o)}}),"HTML"!==e(i).get(0).tagName&&e(i).parent("[rev]").each(function(){var t=e(this).attr("rev");t&&(s[e(this).attr("rev")]=n.getElementSubject(this))}),s},findSubjectElements:function(t){return e("[about]",t)},findPredicateElements:function(t,i,r){var n=this;return e(i).find(this.options.predicateSelector).add(e(i).filter(this.options.predicateSelector)).filter(function(){return n.getElementSubject(this)!==t?!1:r?!0:e(this).parents("[property]").length?!1:!0})},parseElementValue:function(t,e){if(!e.attr("datatype"))return t;var i=this.vie.namespaces.uri(e.attr("datatype"));return this.datatypeReaders[i]?this.datatypeReaders[i](t):t},generateElementValue:function(t,e){if(!e.attr("datatype"))return t;var i=this.vie.namespaces.uri(e.attr("datatype"));return this.datatypeWriters[i]?this.datatypeWriters[i](t):t},readElementValue:function(t,i){var r=i.attr("content");if(r)return this.parseElementValue(r,i);var n=i.attr("resource");if(n)return["<"+n+">"];var s=i.attr("href");if(s&&i.attr("rel")===t)return["<"+s+">"];if(i.attr("rel")){var o=[],a=this;return e(i).children(this.options.subjectSelector).each(function(){o.push(a.getElementSubject(this,!0))}),o}return this.parseElementValue(i.html(),i)},writeElementValue:function(t,e,i){i=this.generateElementValue(i,e),r.isArray(i)&&i.length>0&&(i=i[0]);var n=e.attr("content");if(n)return e.attr("content",i),void 0;var s=e.attr("resource");s&&e.attr("resource",i),e.html(i)},xmlns:function(t){var i;if(t)i=e(t);else{if("undefined"==typeof document)return{};i=e(document)}i=i.add(i.parents());var r={};return i.each(function(t,e){if(e.attributes)for(t=0;e.attributes.length>t;t+=1){var i=e.attributes[t];if(/^xmlns(:(.+))?$/.test(i.nodeName)){var n=/^xmlns(:(.+))?$/.exec(i.nodeName)[2]||"",s=i.nodeValue;(""===n||""!==s)&&(r[n]=i.nodeValue)}}}),r}}}(),function(){var t=["http://demo.iks-project.eu/stanbolfull","http://dev.iks-project.eu/stanbolfull"];n.prototype.StanbolService=function(i){var r={name:"stanbol",url:t,timeout:2e4,namespaces:{semdeski:"http://www.semanticdesktop.org/ontologies/2007/01/19/nie#",semdeskf:"http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#",skos:"http://www.w3.org/2004/02/skos/core#",foaf:"http://xmlns.com/foaf/0.1/",opengis:"http://www.opengis.net/gml/",dbpedia:"http://dbpedia.org/ontology/",dbprop:"http://dbpedia.org/property/",owl:"http://www.w3.org/2002/07/owl#",geonames:"http://www.geonames.org/ontology#",enhancer:"http://fise.iks-project.eu/ontology/",entityhub:"http://www.iks-project.eu/ontology/rick/model/",entityhub2:"http://www.iks-project.eu/ontology/rick/query/",rdf:"http://www.w3.org/1999/02/22-rdf-syntax-ns#",rdfs:"http://www.w3.org/2000/01/rdf-schema#",dcterms:"http://purl.org/dc/terms/",schema:"http://schema.org/",geo:"http://www.w3.org/2003/01/geo/wgs84_pos#"},rules:[{left:["?subject a <http://fise.iks-project.eu/ontology/EntityAnnotation>","?subject enhancer:entity-type ?type","?subject enhancer:confidence ?confidence","?subject enhancer:entity-reference ?entity","?subject dcterms:relation ?relation","?relation a <http://fise.iks-project.eu/ontology/TextAnnotation>","?relation enhancer:selected-text ?selected-text","?relation enhancer:selection-context ?selection-context","?relation enhancer:start ?start","?relation enhancer:end ?end"],right:["?entity a ?type","?entity enhancer:hasTextAnnotation ?relation","?entity enhancer:hasEntityAnnotation ?subject"]}],enhancer:{chain:"default"},entityhub:{site:void 0}};this.options=e.extend(!0,r,i?i:{}),this.vie=null,this.name=this.options.name},n.prototype.StanbolService.prototype={init:function(){for(var t in this.options.namespaces){var i=this.options.namespaces[t];this.vie.namespaces.add(t,i)}this.rules=e.extend([],n.Util.transformationRules(this)),this.rules=e.merge(this.rules,this.options.rules?this.options.rules:[]),this.connector=new this.vie.StanbolConnector(this.options),this.vie.types.addOrOverwrite("enhancer:EntityAnnotation",[]).inherit("owl:Thing"),this.vie.types.addOrOverwrite("enhancer:TextAnnotation",[]).inherit("owl:Thing"),this.vie.types.addOrOverwrite("enhancer:Enhancement",[]).inherit("owl:Thing")},analyze:function(t){var i=this,s=t instanceof this.vie.Analyzable;if(!s)throw"Invalid Analyzable passed";var o=t.options.element?t.options.element:e("body"),a=i._extractText(o);if(a.length>0){var c=function(e){r.defer(function(){var r=n.Util.rdf2Entities(i,e);i.vie.entities.addOrUpdate(r),t.resolve(r)})},u=function(e){t.reject(e)},p={chain:t.options.chain?t.options.chain:i.options.enhancer.chain};this.connector.analyze(a,c,u,p)}else t.resolve([])},find:function(t){var e=t instanceof this.vie.Findable;if(!e)throw"Invalid Findable passed";var i=this;t.options.term||t.reject([]);var s=t.options.term,o=t.options.limit===void 0?20:t.options.limit,a=t.options.offset===void 0?0:t.options.offset,c=function(e){r.defer(function(){var r=n.Util.rdf2Entities(i,e);t.resolve(r)})},u=function(e){t.reject(e)};t.options.site=t.options.site?t.options.site:i.options.entityhub.site;var p=this.vie;if(t.options.properties){var h=t.options.properties;t.options.ldPath=r(h).map(function(t){return p.namespaces.isCurie(t)?p.namespaces.uri(t)+";":t}).join("")}if(t.options.field&&p.namespaces.isCurie(l)){var l=t.options.field;t.options.field=p.namespaces.uri(l)}this.connector.find(s,o,a,c,u,t.options)},load:function(t){var e=t instanceof this.vie.Loadable;if(!e)throw"Invalid Loadable passed";var i=this,s=t.options.entity;s||t.resolve([]);var o=function(e){r.defer(function(){var s=n.Util.rdf2Entities(i,e);r.each(s,function(t){i.vie.entities.addOrUpdate(t)}),t.resolve(s)})},a=function(e){t.reject(e)},c={site:t.options.site?t.options.site:i.options.entityhub.site,local:t.options.local};this.connector.load(s,o,a,c)},save:function(t){var e=t instanceof this.vie.Savable;if(!e)throw"Invalid Savable passed";var i=this,s=t.options.entity;s||t.reject("StanbolConnector: No entity to save!");var o=function(e){r.defer(function(){var r=n.Util.rdf2Entities(i,e);t.resolve(r)})},a=function(e){t.reject(e)},c={site:t.options.site?t.options.site:i.options.entityhub.site,local:t.options.local};this.connector.save(s,o,a,c)},_extractText:function(t){if(t.get(0)&&t.get(0).tagName&&("TEXTAREA"==t.get(0).tagName||"INPUT"==t.get(0).tagName&&t.attr("type","text")))return t.get(0).val();var i=t.text().replace(/\s+/g," ").replace(/\0\b\n\r\f\t/g,"");return e.trim(i)}},n.prototype.StanbolConnector=function(i){var n={url:t,timeout:2e4,enhancer:{urlPostfix:"/enhancer",chain:"default"},entityhub:{site:void 0,urlPostfix:"/entityhub",local:!1},sparql:{urlPostfix:"/sparql"},contenthub:{urlPostfix:"/contenthub",index:"contenthub"},ontonet:{urlPostfix:"/ontonet"},factstore:{urlPostfix:"/factstore"},rules:{urlPostfix:"/rules"},cmsadapter:{urlPostfix:"/cmsadapter"}};this.options=e.extend(!0,n,i?i:{}),this.options.url=r.isArray(this.options.url)?this.options.url:[this.options.url],this._init(),this.baseUrl=r.isArray(i.url)?i.url:[i.url]},n.prototype.StanbolConnector.prototype={_init:function(){var t=this;return e.ajaxSetup({converters:{"text application/rdf+json":function(t){return JSON.parse(t)}},timeout:t.options.timeout}),this},_iterate:function(t){if(t){if(t.urlIndex>=this.options.url.length)return t.error.call(this,"Could not connect to the given Stanbol endpoints! Please check for their setup!"),void 0;var e=function(t,e){return function(){e.urlIndex=e.urlIndex+1,t._iterate(e)}}(this,t);return"undefined"!=typeof exports&&"undefined"!=typeof process?t.methodNode.call(this,t.url.call(this,t.urlIndex,t.args.options),t.args,t.success,e):t.method.call(this,t.url.call(this,t.urlIndex,t.args.options),t.args,t.success,e)}},analyze:function(t,e,i,r){r=r?r:{};var n=this;n._iterate({method:n._analyze,methodNode:n._analyzeNode,url:function(t,e){var i=e.chain?e.chain:this.options.enhancer.chain,r=this.options.url[t].replace(/\/$/,"");return r+=this.options.enhancer.urlPostfix+"/chain/"+i.replace(/\/$/,"")},args:{text:t,format:r.format||"application/rdf+json",options:r},success:e,error:i,urlIndex:0})},_analyze:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"POST",data:i.text,dataType:i.format,contentType:"text/plain",accepts:{"application/rdf+json":"application/rdf+json"}})},_analyzeNode:function(t,e,i,r){var n=require("request"),s=n({method:"POST",uri:t,body:e.text,headers:{Accept:e.format,"Content-Type":"text/plain"}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},load:function(t,e,i,r){var n=this;r=r?r:{},r.uri=t.replace(/^</,"").replace(/>$/,""),n._iterate({method:n._load,methodNode:n._loadNode,success:e,error:i,url:function(t,e){var i=e.site?e.site:this.options.entityhub.site;i=i?"/"+i:"s";var r=e.local,n=this.options.url[t].replace(/\/$/,"")+this.options.entityhub.urlPostfix;return n+=r?"/entity?id="+encodeURIComponent(e.uri):"/site"+i+"/entity?id="+encodeURIComponent(e.uri)},args:{format:r.format||"application/rdf+json",options:r},urlIndex:0})},_load:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"GET",dataType:i.format,contentType:"text/plain",accepts:{"application/rdf+json":"application/rdf+json"}})},_loadNode:function(t,e,i,r){var n=require("request"),s=n({method:"GET",uri:t,body:e.text,headers:{Accept:e.format}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},find:function(t,e,i,r,n,s){s=s?s:{};var o=this;return t&&""!==t?(i=i?i:0,e=e?e:10,o._iterate({method:o._find,methodNode:o._findNode,success:r,error:n,url:function(t,e){var i=e.site?e.site:this.options.entityhub.site;i=i?"/"+i:"s";var r=e.local,n=this.options.url[t].replace(/\/$/,"")+this.options.entityhub.urlPostfix;return n+=r?"/sites/find":"/site"+i+"/find"},args:{term:t,offset:i,limit:e,format:s.format||"application/rdf+json",options:s},urlIndex:0}),void 0):(n("No term given!"),void 0)},_find:function(t,i,r,n){var s={name:i.term,limit:i.limit,offset:i.offset};e.ajax({success:r,error:n,url:t,type:"POST",data:e.param(s),dataType:i.format,contentType:"application/x-www-form-urlencoded",accepts:{"application/rdf+json":"application/rdf+json"}})},_findNode:function(t,e,i,r){var n=require("request"),s=n({method:"POST",uri:t,body:"name="+e.term+"&limit="+e.limit+"&offset="+e.offset,headers:{Accept:e.format}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},lookup:function(t,e,i,r){r=r?r:{};var n=this;t=t.replace(/^</,"").replace(/>$/,""),r.uri=t,r.create=r.create?r.create:!1,n._iterate({method:n._lookup,methodNode:n._lookupNode,success:e,error:i,url:function(t,e){var i=this.options.url[t].replace(/\/$/,"")+this.options.entityhub.urlPostfix;return i+="/lookup?id="+encodeURIComponent(e.uri)+"&create="+e.create},args:{format:r.format||"application/rdf+json",options:r},urlIndex:0})},_lookup:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"GET",dataType:i.format,contentType:"text/plain",accepts:{"application/rdf+json":"application/rdf+json"}})},_lookupNode:function(t,e,i,r){var n=require("request"),s=n({method:"GET",uri:t,body:e.text,headers:{Accept:e.format}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},referenced:function(t,e,i){i=i?i:{};var n=this,s=function(e){r.isArray(e)||(e=JSON.parse(e));for(var i=[],n=0,s=e.length;s>n;n++)i.push(e[n].replace(/.+\/(.+?)\/?$/,"$1"));return t(i)};n._iterate({method:n._referenced,methodNode:n._referencedNode,success:s,error:e,url:function(t){var e=this.options.url[t].replace(/\/$/,"");return e+=this.options.entityhub.urlPostfix+"/sites/referenced"},args:{options:i},urlIndex:0})},_referenced:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"GET",accepts:{"application/rdf+json":"application/rdf+json"}})},_referencedNode:function(t,e,i,r){var n=require("request"),s=n({method:"GET",uri:t,headers:{Accept:e.format}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},sparql:function(t,e,i,r){r=r?r:{};var n=this;n._iterate({method:n._sparql,methodNode:n._sparqlNode,success:e,error:i,url:function(t){var e=this.options.url[t].replace(/\/$/,"");return e+=this.options.sparql.urlPostfix.replace(/\/$/,"")},args:{query:t,options:r},urlIndex:0})},_sparql:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"POST",data:"query="+i.query,contentType:"application/x-www-form-urlencoded"})},_sparqlNode:function(t,e,i,r){var n=require("request"),s=n({method:"POST",uri:t,body:JSON.stringify({query:e.query}),headers:{Accept:e.format}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},ldpath:function(t,e,i,n,s){s=s?s:{};var o=this;e=r.isArray(e)?e:[e];for(var a="",c=0;e.length>c;c++)a+="&context="+e[c];o._iterate({method:o._ldpath,methodNode:o._ldpathNode,success:i,error:n,url:function(t,e){var i=e.site?e.site:this.options.entityhub.site;i=i?"/"+i:"s";var r=e.local,n=this.options.url[t].replace(/\/$/,"")+this.options.entityhub.urlPostfix;return r||(n+="/site"+i),n+="/ldpath"},args:{ldpath:t,context:a,format:s.format||"application/rdf+json",options:s},urlIndex:0})},_ldpath:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"POST",data:"ldpath="+i.ldpath+i.context,contentType:"application/x-www-form-urlencoded",dataType:i.format,accepts:{"application/rdf+json":"application/rdf+json"}})},_ldpathNode:function(t,e,i,r){var n=require("request"),s=n({method:"POST",uri:t,body:"ldpath="+e.ldpath+e.context,headers:{Accept:e.format}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},uploadContent:function(t,e,i,r){r=r?r:{};var n=this;n._iterate({method:n._uploadContent,methodNode:n._uploadContentNode,success:e,error:i,url:function(t,e){var i=this.options.url[t].replace(/\/$/,"");i+=this.options.contenthub.urlPostfix.replace(/\/$/,"");var r=e.index?e.index:this.options.contenthub.index;return i+="/"+r.replace(/\/$/,""),i+="/store"},args:{content:t,options:r},urlIndex:0})},_uploadContent:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"POST",data:i.content,contentType:"text/plain"})},_uploadContentNode:function(t,e,i,r){var n=require("request"),s=n({method:"POST",uri:t,body:e.content,headers:{Accept:"application/rdf+xml","Content-Type":"text/plain"}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},createFactSchema:function(t,e,i,r,n){n=n?n:{};var s=this;n.url=t,s._iterate({method:s._createFactSchema,methodNode:s._createFactSchemaNode,success:i,error:r,url:function(t,e){var i=this.options.url[t].replace(/\/$/,"");return i+=this.options.factstore.urlPostfix.replace(/\/$/,""),i+="/facts/"+encodeURIComponent(e.url)},args:{url:t,schema:e,options:n},urlIndex:0})},_createFactSchema:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"PUT",data:i.schema,contentType:"application/json",dataType:"application/json"})},_createFactSchemaNode:function(t,e,i,r){var n=require("request"),s=n({method:"PUT",uri:t,body:e.schema,headers:{Accept:"application/json","Content-Type":"application/json"}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},createFact:function(t,e,i,r){r=r?r:{};var n=this;n._iterate({method:n._createFact,methodNode:n._createFactNode,success:e,error:i,url:function(t){var e=this.options.url[t].replace(/\/$/,"");return e+=this.options.factstore.urlPostfix.replace(/\/$/,""),e+="/facts"},args:{fact:t,options:r},urlIndex:0})},_createFact:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"POST",data:i.fact,contentType:"application/json",dataType:"application/json"})},_createFactNode:function(t,e,i,r){var n=require("request"),s=n({method:"POST",uri:t,body:e.fact,headers:{Accept:"application/json","Content-Type":"application/json"}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()},queryFact:function(t,e,i,r){r=r?r:{};var n=this;n._iterate({method:n._queryFact,methodNode:n._queryFactNode,success:e,error:i,url:function(t){var e=this.options.url[t].replace(/\/$/,"");return e+=this.options.factstore.urlPostfix.replace(/\/$/,""),e+="/query"},args:{query:t,options:r},urlIndex:0})},_queryFact:function(t,i,r,n){e.ajax({success:r,error:n,url:t,type:"POST",data:i.query,contentType:"application/json",dataType:"application/json"})},_queryFactNode:function(t,e,i,r){var n=require("request"),s=n({method:"POST",uri:t,body:e.query,headers:{Accept:"application/json","Content-Type":"application/json"}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()}}}(),function(){n.prototype.ZemantaService=function(t){var i={name:"zemanta",url:["http://api.zemanta.com/services/rest/0.0/"],timeout:2e4,namespaces:{zemanta:"http://s.zemanta.com/ns#"},rules:[{left:["?subject a zemanta:Recognition","?subject zemanta:object ?object","?object owl:sameAs ?entity"],right:["?entity zemanta:hasEntityAnnotation ?subject"]}],api_key:void 0};this.options=e.extend(!0,i,t?t:{}),this.vie=null,this.name=this.options.name,e.ajaxSetup({converters:{"text application/rdf+json":function(t){return JSON.parse(t)}},timeout:this.options.timeout})},n.prototype.ZemantaService.prototype={init:function(){for(var t in this.options.namespaces){var i=this.options.namespaces[t];this.vie.namespaces.add(t,i)}this.rules=e.extend([],n.Util.transformationRules(this)),this.rules=e.merge(this.rules,this.options.rules?this.options.rules:[]),this.connector=new this.vie.ZemantaConnector(this.options),this.vie.types.addOrOverwrite("zemanta:Recognition",[]).inherit("owl:Thing")},analyze:function(t){var i=this,s=t instanceof this.vie.Analyzable;if(!s)throw"Invalid Analyzable passed";var o=t.options.element?t.options.element:e("body"),a=i._extractText(o);if(a.length>0){var c=function(e){r.defer(function(){var r=n.Util.rdf2Entities(i,e);t.resolve(r)})},u=function(e){t.reject(e)},p={};this.connector.analyze(a,c,u,p)}else t.resolve([])},_extractText:function(t){return e(t).wrap("<div>").parent().html()}},n.prototype.ZemantaConnector=function(t){var i={url:["http://api.zemanta.com/services/rest/0.0/"],timeout:2e4,api_key:void 0};this.options=e.extend(!0,i,t?t:{}),this.options.url=r.isArray(this.options.url)?this.options.url:[this.options.url],this._init(),this.baseUrl=r.isArray(t.url)?t.url:[t.url]},n.prototype.ZemantaConnector.prototype={_init:function(){var t=this;return e.ajaxSetup({converters:{"text application/rdf+json":function(t){return JSON.parse(t)
}},timeout:t.options.timeout}),this},_iterate:function(t){if(t){if(t.urlIndex>=this.options.url.length)return t.error.call(this,"Could not connect to the given Zemanta endpoints! Please check for their setup!"),void 0;var e=function(t,e){return function(){e.urlIndex=e.urlIndex+1,t._iterate(e)}}(this,t);return"undefined"!=typeof exports&&"undefined"!=typeof process?t.methodNode.call(this,t.url.call(this,t.urlIndex,t.args.options),t.args,t.success,e):t.method.call(this,t.url.call(this,t.urlIndex,t.args.options),t.args,t.success,e)}},analyze:function(t,e,i,r){r=r?r:{};var n=this;n._iterate({method:n._analyze,methodNode:n._analyzeNode,success:e,error:i,url:function(t){var e=this.options.url[t].replace(/\/$/,"");return e},args:{text:t,format:r.format||"rdfxml",options:r},urlIndex:0})},_analyze:function(t,i,r,n){e.ajax({success:function(t,e,i){var n=i.responseText.replace(/<z:signature>.*?<\/z:signature>/,"");r(n)},error:n,url:t,type:"POST",dataType:"xml",data:{method:"zemanta.suggest",text:i.text,format:i.format,api_key:this.options.api_key,return_rdf_links:i.options.return_rdf_links},contentType:"text/plain",accepts:{"application/rdf+json":"application/rdf+json"}})},_analyzeNode:function(t,e,i,r){var n=require("request"),s=n({method:"POST",uri:t,body:e.text,headers:{Accept:e.format,"Content-Type":"text/plain"}},function(t,e,n){try{i({results:JSON.parse(n)})}catch(s){r(s)}});s.end()}}}(),n.prototype.view||(n.prototype.view={}),n.prototype.view.Collection=i.View.extend({initialize:function(){if(this.templates=this.options.templates,this.service=this.options.service,!this.service)throw"No RDFa service provided to the Collection View";this.owner=this.options.owner,this.definition=this.options.definition,this.entityViews={},this.listenTo(this.collection,"add",this.addItem),this.listenTo(this.collection,"remove",this.removeItem),this.listenTo(this.collection,"reset",this.refreshItems),this.collection.each(function(t){this.registerItem(t,this.collection)},this)},canAdd:function(t){return r.isEmpty(this.templates)?!1:t&&!this.templates[t]?!1:this.collection.canAdd(t)},addItem:function(t,e){if(e===this.collection){var i,n=t.get("@type");if(r.isArray(n)?r.each(n,function(t){this.canAdd(t.id)&&(i=t.id)},this):this.canAdd(n.id)&&(i=n.id),i){var s=this;this.templates[i](t,function(i){var r=s.service._registerEntityView(t,i,!0),n=r.render().$el;t.id&&s.service.setElementSubject(t.getSubjectUri(),n);var o=e.indexOf(t);if(0===o)s.$el.prepend(n);else{var a=e.at(o-1),c=s.entityViews[a.cid];c?c.$el.after(n):s.$el.append(n)}s.findReverseRelations(t,n),s.trigger("add",r),s.entityViews[t.cid]=r,n.show()},this)}}},findReverseRelations:function(t,i){var r=this.service;i.parent("[rev]").each(function(){var i=e(this).attr("rev"),n={};n[i]=new r.vie.Collection([],{vie:r.vie,predicate:i});var s=r.vie.entities.get(r.getElementSubject(this));s&&n[i].addOrUpdate(s),t.set(n)})},registerItem:function(t){var e=this.service.getElementBySubject(t.id,this.el);if(e){var i=this.service._registerEntityView(t,e);this.entityViews[t.cid]=i}},removeItem:function(t){this.entityViews[t.cid]&&(this.trigger("remove",this.entityViews[t.cid]),e(this.entityViews[t.cid].el).remove(),delete this.entityViews[t.cid])},refreshItems:function(t){r.each(this.entityViews,function(t){e(t.el).remove()}),this.entityViews={},t.forEach(function(e){this.addItem(e,t)},this)}}),n.prototype.view||(n.prototype.view={}),n.prototype.view.Entity=i.View.extend({initialize:function(t){this.service=t.service?t.service:"rdfa",this.vie=t.vie,this.listenTo(this.model,"change",this.render),this.listenTo(this.model,"change:@subject",this.renderAbout)},render:function(){return this.vie.save({element:this.el,entity:this.model}).to(this.service).execute(),this},renderAbout:function(){this.vie.service(this.service).setElementSubject(this.model.getSubjectUri(),this.el)}});var t=this;(function(e){t.XDomainRequest&&e.ajaxTransport(function(t){if(t.crossDomain&&t.async){t.timeout&&(t.xdrTimeout=t.timeout,delete t.timeout);var i;return{send:function(r,n){function s(t,r,s,o){i.onload=i.onerror=i.ontimeout=e.noop,i=void 0,n(t,r,s,o)}if(i=new XDomainRequest,t.dataType){var o="header_Accept="+encodeURIComponent(t.dataType)+"&header_Content-Type=text/plain";t.url=t.url+(-1===t.url.indexOf("?")?"?":"&")+o}i.open(t.type,t.url),i.onload=function(){s(200,"OK",{text:i.responseText},"Content-Type: "+i.contentType)},i.onerror=function(){s(404,"Not Found")},t.xdrTimeout&&(i.ontimeout=function(){s(0,"timeout")},i.timeout=t.xdrTimeout),i.send(t.hasContent&&t.data||null)},abort:function(){i&&(i.onerror=e.noop(),i.abort())}}}})})(e)})();