/* Create.js 1.0.0alpha4 - Inline editing toolkit
by Henri Bergius and contributors. Available under the MIT license.
See http://createjs.org for more information
*/!function(a,b){"use strict";a.widget("Midgard.midgardCreate",{options:{toolbar:"full",saveButton:null,state:"browse",highlight:!0,highlightColor:"#67cc08",editorWidgets:{"default":"hallo"},editorOptions:{hallo:{widget:"halloWidget"}},collectionWidgets:{"default":"midgardCollectionAdd"},url:function(){},storagePrefix:"node",workflows:{url:null},notifications:{},vie:null,domService:"rdfa",stanbolUrl:null,dbPediaUrl:null,metadata:{},buttonContainer:".create-ui-toolbar-statustoolarea .create-ui-statustools",templates:{buttonContent:'<%= label %> <i class="icon-<%= icon %>"></i>',button:'<li id="<%= id %>"><a class="create-ui-btn"><%= buttonContent %></a></li>'},localize:function(a,b){return window.midgardCreate.localize(a,b)},language:null},_create:function(){this.vie=this._setupVIE(this.options),this.domService=this.vie.service(this.options.domService);var b=this;window.setTimeout(function(){b._checkSession()},10),this.options.language||(this.options.language=a("html").attr("lang")),this.options.toolbar&&this._enableToolbar(),this._enableMetadata(),this._saveButton(),this._editButton(),this._prepareStorage(),this.element.midgardWorkflows&&this.element.midgardWorkflows(this.options.workflows),this.element.midgardNotifications&&this.element.midgardNotifications(this.options.notifications),this._bindShortcuts()},destroy:function(){this.element.midgardStorage("destroy"),this.element.midgardToolbar("destroy"),this.domService.findSubjectElements(this.element).each(function(){a(this).midgardEditable("destroy")}),this.element.midgardWorkflows&&this.element.midgardWorkflows("destroy"),this.element.midgardNotifications&&this.element.midgardNotifications("destroy"),_.isEmpty(this.options.metadata)||this.element.midgardMetadata("destroy"),a.Widget.prototype.destroy.call(this)},_setupVIE:function(a){var b;return b=a.vie?a.vie:new VIE,b.hasService(this.options.domService)||"rdfa"!==this.options.domService||b.use(new b.RdfaService),!b.hasService("stanbol")&&a.stanbolUrl&&b.use(new b.StanbolService({proxyDisabled:!0,url:a.stanbolUrl})),!b.hasService("dbpedia")&&a.dbPediaUrl&&b.use(new b.DBPediaService({proxyDisabled:!0,url:a.dbPediaUrl})),b},_prepareStorage:function(){this.element.midgardStorage({vie:this.vie,url:this.options.url,localize:this.options.localize,language:this.options.language,storagePrefix:this.options.storagePrefix});var b=this;this.element.on("midgardstoragesave",function(){a("#midgardcreate-save a").html(_.template(b.options.templates.buttonContent,{label:b.options.localize("Saving",b.options.language),icon:"upload"}))}),this.element.on("midgardstoragesaved midgardstorageerror",function(){a("#midgardcreate-save a").html(_.template(b.options.templates.buttonContent,{label:b.options.localize("Save",b.options.language),icon:"ok"}))})},_init:function(){this.setState(this.options.state)},setState:function(a){this._setOption("state",a),"edit"===a?this._enableEdit():this._disableEdit(),this._setEditButtonState(a)},setToolbar:function(a){this.options.toolbar=a,(this.element.data("Midgard-midgardToolbar")||this.element.data("midgardToolbar"))&&this.element.midgardToolbar("setDisplay",a)},showNotification:function(a){return this.element.midgardNotifications?this.element.midgardNotifications("create",a):void 0},configureEditor:function(a,b,c){this.options.editorOptions[a]={widget:b,options:c}},setEditorForContentType:function(a,c){if(this.options.editorOptions[c]===b&&null!==c)throw new Error("No editor "+c+" configured");this.options.editorWidgets[a]=c},setEditorForProperty:function(a,c){if(this.options.editorOptions[c]===b&&null!==c)throw new Error("No editor "+c+" configured");this.options.editorWidgets[a]=c},_checkSession:function(){if(window.sessionStorage){var a=this.options.storagePrefix+"Midgard.create.toolbar";window.sessionStorage.getItem(a)&&this.setToolbar(window.sessionStorage.getItem(a));var b=this.options.storagePrefix+"Midgard.create.state";window.sessionStorage.getItem(b)&&this.setState(window.sessionStorage.getItem(b)),this.element.on("midgardcreatestatechange",function(a,c){window.sessionStorage.setItem(b,c.state)})}},_bindShortcuts:function(){if(window.Mousetrap){var a=this;window.Mousetrap.bind(["command+e","ctrl+e"],function(){"edit"!==a.options.state&&a.setState("edit")}),window.Mousetrap.bind("esc",function(b){"browse"!==a.options.state&&(b.stopPropagation(),a.setState("browse"))}),window.Mousetrap.bind(["command+s","ctrl+s"],function(b){b.preventDefault(),a.options.saveButton&&(a.options.saveButton.hasClass("ui-state-disabled")||a.options.saveButton.click())})}},_saveButton:function(){if(this.options.saveButton)return this.options.saveButton;var b=this;a(this.options.buttonContainer,this.element).append(a(_.template(this.options.templates.button,{id:"midgardcreate-save",buttonContent:_.template(this.options.templates.buttonContent,{label:b.options.localize("Save",b.options.language),icon:"ok"})}))),this.options.saveButton=a("#midgardcreate-save",this.element),this.options.saveButton.hide(),this.options.saveButton.click(function(){b.element.midgardStorage("saveRemoteAll")}),this.element.on("midgardeditablechanged midgardstorageloaded",function(){b.options.saveButton.button({disabled:!1})}),this.element.on("midgardstoragesaved",function(){b.options.saveButton.button({disabled:!0})}),this.element.on("midgardeditableenable",function(){b.options.saveButton.button({disabled:!0}),b.options.saveButton.show()}),this.element.on("midgardeditabledisable",function(){b.options.saveButton.hide()})},_editButton:function(){var b=this;a(this.options.buttonContainer,this.element).append(a(_.template(this.options.templates.button,{id:"midgardcreate-edit",buttonContent:""}))),a("#midgardcreate-edit",this.element).on("click",function(){return"edit"===b.options.state?void b.setState("browse"):void b.setState("edit")})},_setEditButtonState:function(b){var c=this,d={edit:_.template(this.options.templates.buttonContent,{label:c.options.localize("Cancel",c.options.language),icon:"remove"}),browse:_.template(this.options.templates.buttonContent,{label:c.options.localize("Edit",c.options.language),icon:"edit"})},e=a("#midgardcreate-edit a",this.element);e&&("edit"===b&&e.addClass("selected"),e.html(d[b]))},_enableToolbar:function(){var a=this;this.element.on("midgardtoolbarstatechange",function(b,c){a.setToolbar(c.display),window.sessionStorage&&window.sessionStorage.setItem(a.options.storagePrefix+"Midgard.create.toolbar",c.display)}),this.element.midgardToolbar({display:this.options.toolbar,vie:this.vie})},_enableMetadata:function(){_.isEmpty(this.options.metadata)||a(".create-ui-tool-metadataarea",this.element).midgardMetadata({vie:this.vie,localize:this.options.localize,language:this.options.language,editors:this.options.metadata,createElement:this.element,editableNs:"midgardeditable"})},_enableEdit:function(){this._setOption("state","edit");var b=this,c={toolbarState:b.options.toolbar,disabled:!1,vie:b.vie,domService:b.options.domService,widgets:b.options.editorWidgets,editors:b.options.editorOptions,collectionWidgets:b.options.collectionWidgets,localize:b.options.localize,language:b.options.language};b.options.enableEditor&&(c.enableEditor=b.options.enableEditor),b.options.disableEditor&&(c.disableEditor=b.options.disableEditor),this.domService.findSubjectElements(this.element).each(function(){var d=this;if(b.options.highlight){var e=function(c,e){a(e.element).is(":visible")&&e.entityElement.get(0)===d&&(window.Mousetrap&&e.element.addClass("mousetrap"),e.element.stop(!0,!0),e.element.effect("highlight",{color:b.options.highlightColor},3e3))};a(this).on("midgardeditableenableproperty",e)}a(this).on("midgardeditabledisable",function(){a(this).off("midgardeditableenableproperty",e)}),a(this).midgardEditable(c)}),this._trigger("statechange",null,{state:"edit"})},_disableEdit:function(){var b=this,c={disabled:!0,vie:b.vie,domService:b.options.domService,editorOptions:b.options.editorOptions,localize:b.options.localize,language:b.options.language};this.domService.findSubjectElements(this.element).each(function(){a(this).midgardEditable(c),a(this).removeClass("ui-state-disabled")}),this._setOption("state","browse"),this._trigger("statechange",null,{state:"browse"})}})}(jQuery),function(a,b){"use strict";a.widget("Midgard.midgardEditable",{options:{propertyEditors:{},collections:[],model:null,propertyEditorWidgetsConfiguration:{hallo:{widget:"halloWidget",options:{}}},propertyEditorWidgets:{"default":"hallo"},collectionWidgets:{"default":"midgardCollectionAdd"},toolbarState:"full",vie:null,domService:"rdfa",predicateSelector:"[property]",disabled:!1,localize:function(a,b){return window.midgardCreate.localize(a,b)},language:null,state:null,acceptStateChange:!0,stateChange:null,decorateEditableEntity:null,decoratePropertyEditor:null,editables:[],editors:{},widgets:{}},_params:function(a,b){var c={entity:this.options.model,editableEntity:this,entityElement:this.element,editable:this,element:this.element,instance:this.options.model},d=a?{predicate:a,propertyEditor:this.options.propertyEditors[a],propertyElement:this.options.propertyEditors[a].element,property:a,element:this.options.propertyEditors[a].element}:{};return _.extend(c,d,b)},_create:function(){if(this.options.widgets&&(this.options.propertyEditorWidgets=_.extend(this.options.propertyEditorWidgets,this.options.widgets)),this.options.editors&&(this.options.propertyEditorWidgetsConfiguration=_.extend(this.options.propertyEditorWidgetsConfiguration,this.options.editors)),this.vie=this.options.vie,this.domService=this.vie.service(this.options.domService),!this.options.model){var a=this;this.vie.load({element:this.element}).from(this.options.domService).execute().done(function(b){a.options.model=b[0]})}_.isFunction(this.options.decorateEditableEntity)&&this.options.decorateEditableEntity(this._params())},_init:function(){return this.options.widgets&&(this.options.propertyEditorWidgets=_.extend(this.options.propertyEditorWidgets,this.options.widgets)),this.options.editors&&(this.options.propertyEditorWidgetsConfiguration=_.extend(this.options.propertyEditorWidgetsConfiguration,this.options.editors)),this.options.disabled===!0?void this.setState("inactive"):this.options.disabled===!1&&"inactive"===this.options.state?void this.setState("candidate"):(this.options.disabled=!1,this.options.state?void this.setState(this.options.state):void this.setState("candidate"))},setState:function(a,c,d,e){var f=this.options.state,g=a;if(g!==f){if(this.options.acceptStateChange===b||!_.isFunction(this.options.acceptStateChange))return this._doSetState(f,g,c,d),void(_.isFunction(e)&&e(!0));var h=this;this.options.acceptStateChange(f,g,c,d,function(a){a&&h._doSetState(f,g,c,d),_.isFunction(e)&&e(a)})}},getState:function(){return this.options.state},_doSetState:function(a,b,c,d){this.options.state=b,"inactive"===b?this.disable():null!==a&&"inactive"!==a||"inactive"===b||this.enable(),this._trigger("statechange",null,this._params(c,{previous:a,current:b,context:d}))},findEditablePredicateElements:function(b){this.domService.findPredicateElements(this.options.model.id,a(this.options.predicateSelector,this.element),!1).each(b)},getElementPredicate:function(a){return this.domService.getElementPredicate(a)},enable:function(){var b=this;this.options.model&&(this.findEditablePredicateElements(function(){b._enablePropertyEditor(a(this))}),this._trigger("enable",null,this._params()),this.vie.view&&this.vie.view.Collection&&_.each(this.domService.views,function(a){if(a instanceof this.vie.view.Collection&&this.options.model===a.owner){var c=a.collection.predicate,d=_.clone(this.options);d.state=null;var e=this.enableCollection({model:this.options.model,collection:a.collection,property:c,definition:this.getAttributeDefinition(c),view:a,element:a.el,vie:b.vie,editableOptions:d});b.options.collections.push(e)}},this))},disable:function(){_.each(this.options.propertyEditors,function(a){this.disablePropertyEditor({widget:this,editable:a,entity:this.options.model,element:a.element})},this),this.options.propertyEditors={},this.options.editables=[],_.each(this.options.collections,function(a){var b=_.clone(this.options);b.state="inactive",this.disableCollection({widget:this,model:this.options.model,element:a,vie:this.vie,editableOptions:b})},this),this.options.collections=[],this._trigger("disable",null,this._params())},_enablePropertyEditor:function(a){var b=this,c=this.getElementPredicate(a);if(!c)return!0;if(this.options.model.get(c)instanceof Array)return!0;var d=this.enablePropertyEditor({widget:this,element:a,entity:this.options.model,property:c,vie:this.vie,decorate:this.options.decoratePropertyEditor,decorateParams:_.bind(this._params,this),changed:function(a){b.setState("changed",c);var d={};d[c]=a,b.options.model.set(d,{silent:!0}),b._trigger("changed",null,b._params(c))},activating:function(){b.setState("activating",c)},activated:function(){b.setState("active",c),b._trigger("activated",null,b._params(c))},deactivated:function(){b.setState("candidate",c),b._trigger("deactivated",null,b._params(c))}});if(d){var e=d.data("createWidgetName");this.options.propertyEditors[c]=d.data("Midgard-"+e),this.options.propertyEditors[c]||(this.options.propertyEditors[c]=d.data(e)),this.options.editables.push(d),this._trigger("enableproperty",null,this._params(c))}},_propertyEditorName:function(a){if(this.options.propertyEditorWidgets[a.property]!==b)return this.options.propertyEditorWidgets[a.property];var c="default",d=this.getAttributeDefinition(a.property);return d&&(c=d.range[0]),this.options.propertyEditorWidgets[c]!==b?this.options.propertyEditorWidgets[c]:this.options.propertyEditorWidgets["default"]},_propertyEditorWidget:function(a){return this.options.propertyEditorWidgetsConfiguration[a].widget},_propertyEditorOptions:function(a){return this.options.propertyEditorWidgetsConfiguration[a].options},getAttributeDefinition:function(a){var b=this.options.model.get("@type");if(b&&b.attributes)return b.attributes.get(a)},enableEditor:function(a){return this.enablePropertyEditor(a)},enablePropertyEditor:function(b){var c=this._propertyEditorName(b);if(null!==c){var d=this._propertyEditorWidget(c);if(b.editorOptions=this._propertyEditorOptions(c),b.toolbarState=this.options.toolbarState,b.disabled=!1,b.editorName=c,b.editorWidget=d,"function"!=typeof a(b.element)[d])throw new Error(d+" widget is not available");return a(b.element)[d](b),a(b.element).data("createWidgetName",d),a(b.element)}},disableEditor:function(a){return this.disablePropertyEditor(a)},disablePropertyEditor:function(b){b.element[b.editable.widgetName]({disabled:!0}),a(b.element).removeClass("ui-state-disabled"),b.element.is(":focus")&&b.element.blur()},collectionWidgetName:function(a){if(this.options.collectionWidgets[a.property]!==b)return this.options.collectionWidgets[a.property];var c="default",d=this.getAttributeDefinition(a.property);return d&&(c=d.range[0]),this.options.collectionWidgets[c]!==b?this.options.collectionWidgets[c]:this.options.collectionWidgets["default"]},enableCollection:function(b){var c=this.collectionWidgetName(b);if(null!==c){if(b.disabled=!1,"function"!=typeof a(b.element)[c])throw new Error(c+" widget is not available");return a(b.element)[c](b),a(b.element).data("createCollectionWidgetName",c),a(b.element)}},disableCollection:function(b){var c=a(b.element).data("createCollectionWidgetName");null!==c&&(b.disabled=!0,c&&(a(b.element)[c](b),a(b.element).removeClass("ui-state-disabled")))}})}(jQuery),function(a){"use strict";a.widget("Midgard.midgardMetadata",{contentArea:null,editorElements:{},options:{vie:null,templates:{button:'<button class="create-ui-btn"><i class="icon-<%= icon %>"></i> <%= label %></button>',contentArea:'<div class="dropdown-menu"></div>'},localize:function(a,b){return window.midgardCreate.localize(a,b)},language:null,createElement:"body",editableNs:"midgardeditable"},_create:function(){this._render()},_init:function(){this._prepareEditors(),this._bindEditables()},_prepareEditors:function(){_.each(this.options.editors,function(b,c){var d=a("<div></div>").addClass(c);if(this.contentArea.append(d),!_.isFunction(d[c]))throw new Error("Metadata editor widget "+c+" is not available");_.extend(b,{vie:this.options.vie,language:this.options.language,localize:this.options.localize,createElement:this.options.createElement,editableNs:this.options.editableNs}),d[c](b),this.editorElements[c]=d},this)},activateEditors:function(a){this.element.show(),_.each(this.options.editors,function(b,c){this.editorElements[c]&&this.editorElements[c][c]("activate",a)},this)},_bindEditables:function(){var b=this,c=a(this.options.createElement);c.on(this.options.editableNs+"activated",function(a,c){b.activateEditors({entity:c.entity,entityElement:c.entityElement,predicate:c.predicate})})},_prepareEditorArea:function(){var b=a(_.template(this.options.templates.contentArea,{}));return b.hide(),b},_render:function(){var b=this,c=a(_.template(this.options.templates.button,{icon:"info-sign",label:this.options.localize("Metadata",this.options.language)}));this.element.empty(),this.element.append(c),this.element.hide(),this.contentArea=this._prepareEditorArea(c),c.after(this.contentArea),c.on("click",function(a){a.preventDefault();var d=c.position();b.contentArea.css({position:"absolute",left:d.left}),b.contentArea.toggle()})}})}(jQuery),function(a){"use strict";a.widget("Midgard.midgardStorage",{saveEnabled:!0,options:{localStorage:!1,storagePrefix:"",removeLocalstorageOnIgnore:!0,vie:null,url:"",autoSave:!1,autoSaveInterval:5e3,saveReferencedNew:!1,saveReferencedChanged:!1,editableNs:"midgardeditable",editSelector:"#midgardcreate-edit a",localize:function(a,b){return window.midgardCreate.localize(a,b)},language:null},_create:function(){var a=this;this.changedModels=[],window.localStorage&&(this.options.localStorage=!0),this.vie=this.options.vie,this.vie.entities.on("add",function(b){b.url=a.options.url,b.toJSON=b.toJSONLD}),a._bindEditables(),a.options.autoSave&&a._autoSave()},_autoSave:function(){var a=this;a.saveEnabled=!0;var b=function(){a.saveEnabled&&0!==a.changedModels.length&&a.saveRemoteAll({silent:!0})},c=window.setInterval(b,a.options.autoSaveInterval);this.element.on("startPreventSave",function(){c&&(window.clearInterval(c),c=null),a.disableAutoSave()}),this.element.on("stopPreventSave",function(){c||(c=window.setInterval(b,a.options.autoSaveInterval)),a.enableAutoSave()})},enableAutoSave:function(){this.saveEnabled=!0},disableAutoSave:function(){this.saveEnabled=!1},_bindEditables:function(){var a=this;this.restorables=[];var b;a.element.on(a.options.editableNs+"changed",function(b,c){-1===_.indexOf(a.changedModels,c.instance)?(a.changedModels.push(c.instance),c.instance.midgardStorageVersion=1):c.instance.midgardStorageVersion++,a._saveLocal(c.instance)}),a.element.on(a.options.editableNs+"disable",function(b,c){a.revertChanges(c.instance)}),a.element.on(a.options.editableNs+"enable",function(b,c){c.instance._originalAttributes||(c.instance._originalAttributes=_.clone(c.instance.attributes)),!c.instance.isNew()&&a._checkLocal(c.instance)&&a.restorables.push(c.instance)}),a.element.on("midgardcreatestatechange",function(c,d){return"browse"===d.state||0===a.restorables.length?(a.restorables=[],void(b&&b.close())):void(b=a.checkRestore())}),a.element.on("midgardstorageloaded",function(b,c){-1===_.indexOf(a.changedModels,c.instance)&&a.changedModels.push(c.instance)})},checkRestore:function(){var b=this;if(0!==b.restorables.length){var c,d;c=1===b.restorables.length?_.template(b.options.localize("localModification",b.options.language),{label:b.restorables[0].getSubjectUri()}):_.template(b.options.localize("localModifications",b.options.language),{number:b.restorables.length});var e=function(){b.restoreLocalAll(),d.close()},f=function(){b.ignoreLocal(),d.close()};return d=a("body").midgardNotifications("create",{bindTo:b.options.editSelector,gravity:"TR",body:c,timeout:0,actions:[{name:"restore",label:b.options.localize("Restore",b.options.language),cb:e,className:"create-ui-btn"},{name:"ignore",label:b.options.localize("Ignore",b.options.language),cb:f,className:"create-ui-btn"}],callbacks:{beforeShow:function(){window.Mousetrap&&(window.Mousetrap.bind(["command+shift+r","ctrl+shift+r"],function(a){a.preventDefault(),e()}),window.Mousetrap.bind(["command+shift+i","ctrl+shift+i"],function(a){a.preventDefault(),f()}))},afterClose:function(){window.Mousetrap&&(window.Mousetrap.unbind(["command+shift+r","ctrl+shift+r"]),window.Mousetrap.unbind(["command+shift+i","ctrl+shift+i"]))}}})}},restoreLocalAll:function(){_.each(this.restorables,function(a){this.readLocal(a)},this),this.restorables=[]},ignoreLocal:function(){this.options.removeLocalstorageOnIgnore&&_.each(this.restorables,function(a){this._removeLocal(a)},this),this.restorables=[]},saveReferences:function(a){_.each(a.attributes,function(a){a&&a.isCollection&&a.each(function(a){return-1===this.changedModels.indexOf(a)?a.isNew()&&this.options.saveReferencedNew?a.save():a.hasChanged()&&this.options.saveReferencedChanged?a.save():void 0:void 0},this)},this)},saveRemote:function(a,b){this.saveReferences(a),this._trigger("saveentity",null,{entity:a,options:b});var c=this,d=a.midgardStorageVersion;a.save(null,_.extend({},b,{success:function(e,f){a._originalAttributes=_.clone(a.attributes),c._removeLocal(a),window.setTimeout(function(){a.midgardStorageVersion==d&&c.changedModels.splice(c.changedModels.indexOf(a),1)},0),_.isFunction(b.success)&&b.success(e,f),c._trigger("savedentity",null,{entity:a,options:b})},error:function(a,c){_.isFunction(b.error)&&b.error(a,c)}}))},saveRemoteAll:function(b){var c=this;if(0!==c.changedModels.length){c._trigger("save",null,{entities:c.changedModels,options:b,models:c.changedModels});var d,e=c.changedModels.length;d=e>1?_.template(c.options.localize("saveSuccessMultiple",c.options.language),{number:e}):_.template(c.options.localize("saveSuccess",c.options.language),{label:c.changedModels[0].getSubjectUri()}),c.disableAutoSave(),_.each(c.changedModels,function(f){this.saveRemote(f,{success:function(f,g){e--,0>=e&&(c._trigger("saved",null,{options:b}),b&&_.isFunction(b.success)&&b.success(f,g),a("body").midgardNotifications("create",{body:d}),c.enableAutoSave())},error:function(d,e){b&&_.isFunction(b.error)&&b.error(d,e),a("body").midgardNotifications("create",{body:_.template(c.options.localize("saveError",c.options.language),{error:e.responseText||""}),timeout:0}),c._trigger("error",null,{instance:f})}})},this)}},_saveLocal:function(a){if(this.options.localStorage){if(a.isNew()){if(!a.primaryCollection)return;return this._saveLocalReferences(a.primaryCollection.subject,a.primaryCollection.predicate,a)}var b=this.options.storagePrefix+a.getSubjectUri();window.localStorage.setItem(b,JSON.stringify(a.toJSONLD()))}},_getReferenceId:function(a,b){return a.id+":"+b},_saveLocalReferences:function(a,b,c){if(this.options.localStorage&&a&&b){var d=this.options.storagePrefix+a+":"+b,e=c.toJSONLD();if(window.localStorage.getItem(d)){var f=JSON.parse(window.localStorage.getItem(d)),g=_.pluck(f,"@").indexOf(e["@"]);return-1!==g?f[g]=e:f.push(e),void window.localStorage.setItem(d,JSON.stringify(f))}window.localStorage.setItem(d,JSON.stringify([e]))}},_checkLocal:function(a){if(!this.options.localStorage)return!1;var b=this.options.storagePrefix+a.getSubjectUri(),c=window.localStorage.getItem(b);return c?!0:!1},hasLocal:function(a){if(!this.options.localStorage)return!1;var b=this.options.storagePrefix+a.getSubjectUri();return window.localStorage.getItem(b)?!0:!1},readLocal:function(a){if(this.options.localStorage){var b=this.options.storagePrefix+a.getSubjectUri(),c=window.localStorage.getItem(b);if(c){a._originalAttributes||(a._originalAttributes=_.clone(a.attributes));var d=JSON.parse(c),e=this.vie.entities.addOrUpdate(d,{overrideAttributes:!0});this._trigger("loaded",null,{instance:e})}}},_readLocalReferences:function(a,b,c){if(this.options.localStorage){var d=this.options.storagePrefix+this._getReferenceId(a,b),e=window.localStorage.getItem(d);e&&c.add(JSON.parse(e))}},revertChanges:function(a){var b=this;if(a)return _.each(a.attributes,function(a){if(a instanceof b.vie.Collection){var c=[];a.forEach(function(a){a.isNew()&&c.push(a)}),a.remove(c)}}),a.changedAttributes()?void a.set(a.previousAttributes()):void(a._originalAttributes&&a.set(a._originalAttributes))},_removeLocal:function(a){if(this.options.localStorage){var b=this.options.storagePrefix+a.getSubjectUri();window.localStorage.removeItem(b)}}})}(jQuery),function(a){"use strict";a.widget("Midgard.midgardWorkflows",{options:{url:function(){},templates:{button:'<button class="create-ui-btn" id="<%= id %>"><%= label %></button>'},renderers:{button:function(b,c,d,e){var f="midgardcreate-workflow_"+c.get("name"),g=a(_.template(this.options.templates.button,{id:f,label:c.get("label")})).button();return g.on("click",function(){d(b,c,e)}),g}},action_types:{backbone_save:function(a,b,c){var d=a.url,e=a.clone();e.url=d;var f=b.get("action");f.url&&(a.url=f.url),e.save(null,{success:function(){a.url=d,a.change(),c(null,a)},error:function(b,e){a.url=d,a.change(),c(e,a)}})},backbone_destroy:function(a,b,c){var d=a.url,e=a.clone();e.url=d;var f=b.get("action");f.url&&(a.url=f.url),a.destroy({success:function(b){a.url=d,a.change(),c(null,b)},error:function(b,e){a.url=d,a.change(),c(e,a)}})},http:function(b,c,d){var e=c.get("action");if(!e.url)return d("No action url defined!");var f={};e.http&&(f=e.http);var g=a.extend({url:e.url,type:"POST",data:b.toJSON(),success:function(){b.fetch({success:function(a){d(null,a)},error:function(a,b){d(b,a)}})}},f);a.ajax(g)}}},_init:function(){this._renderers={},this._action_types={},this._parseRenderersAndTypes(),this._last_instance=null,this.ModelWorkflowModel=Backbone.Model.extend({defaults:{name:"",label:"",type:"button",action:{type:"backbone_save"}}}),this.workflows={};var b=this;a(this.element).on("midgardeditableactivated",function(a,c){b._fetchWorkflows(c.instance)})},_fetchWorkflows:function(a){var b=this;if(a.isNew())return void b._trigger("changed",null,{instance:a,workflows:[]});if(b._last_instance==a)return void(b.workflows[a.cid]&&b._trigger("changed",null,{instance:a,workflows:b.workflows[a.cid]}));if(b._last_instance=a,b.workflows[a.cid])return void b._trigger("changed",null,{instance:a,workflows:b.workflows[a.cid]});if(b.options.url)b._fetchModelWorkflows(a);else{var c=new(b._generateCollectionFor(a))([],{});b._trigger("changed",null,{instance:a,workflows:c})}},_parseRenderersAndTypes:function(){var b=this;a.each(this.options.renderers,function(a,c){b.setRenderer(a,c)}),a.each(this.options.action_types,function(a,c){b.setActionType(a,c)})},setRenderer:function(a,b){this._renderers[a]=b},getRenderer:function(a){return this._renderers[a]?this._renderers[a]:!1},setActionType:function(a,b){this._action_types[a]=b},getActionType:function(a){return this._action_types[a]},prepareItem:function(a,b,c){var d=this,e=this.getRenderer(b.get("type")),f=this.getActionType(b.get("action").type);return e.call(this,a,b,f,function(e,f){delete d.workflows[a.cid],d._last_instance=null,"backbone_destroy"!==b.get("action").type&&d._fetchModelWorkflows(a),c(e,f)})},_generateCollectionFor:function(a){var b={model:this.ModelWorkflowModel};return this.options.url&&(b.url=this.options.url(a)),Backbone.Collection.extend(b)},_fetchModelWorkflows:function(a){if(!a.isNew()){var b=this;b.workflows[a.cid]=new(this._generateCollectionFor(a))([],{}),b.workflows[a.cid].fetch({success:function(c){b.workflows[a.cid].reset(c.models),b._trigger("changed",null,{instance:a,workflows:b.workflows[a.cid]})},error:function(){}})}}})}(jQuery),void 0===window.midgardCreate&&(window.midgardCreate={}),window.midgardCreate.localize=function(a,b){return window.midgardCreate.locale?window.midgardCreate.locale[b]&&window.midgardCreate.locale[b][a]?window.midgardCreate.locale[b][a]:window.midgardCreate.locale.en[a]?window.midgardCreate.locale.en[a]:a:a},function(a,b){"use strict";a.widget("Midgard.midgardCollectionAdd",{options:{editingWidgets:null,collection:null,model:null,definition:null,view:null,disabled:!1,vie:null,editableOptions:null,templates:{button:'<button class="btn"><i class="icon-<%= icon %>"></i> <%= label %></button>'}},_create:function(){this.addButtons=[];var a=this;if(!a.options.collection.localStorage)try{a.options.collection.url=a.options.model.url()}catch(b){window.console&&console.log(b)}a.options.collection.on("add",function(b){b.primaryCollection=a.options.collection,a.options.vie.entities.add(b),b.collection=a.options.collection}),a.options.collection.on("add remove reset",a.checkCollectionConstraints,a),a._bindCollectionView(a.options.view)},_bindCollectionView:function(a){var b=this;a.on("add",function(a){a.$el.effect("slide",function(){b._makeEditable(a)})})},_makeEditable:function(a){this.options.editableOptions.disabled=this.options.disabled,this.options.editableOptions.model=a.model,a.$el.midgardEditable(this.options.editableOptions)},_init:function(){return this.options.disabled?void this.disable():void this.enable()},hideButtons:function(){_.each(this.addButtons,function(a){a.hide()})},showButtons:function(){_.each(this.addButtons,function(a){a.show()})},checkCollectionConstraints:function(){return this.options.disabled?void 0:this.options.view.canAdd()?this.options.definition&&this.options.definition.max&&-1!==this.options.definition.max?this.options.collection.length<this.options.definition.max?void this.showButtons():void this.hideButtons():void this.showButtons():void this.hideButtons()},enable:function(){var b=this,c=a(_.template(this.options.templates.button,{icon:"plus",label:this.options.editableOptions.localize("Add",this.options.editableOptions.language)})).button();c.addClass("midgard-create-add"),c.click(function(){b.addItem(c)}),a(b.options.view.el).after(c),b.addButtons.push(c),b.checkCollectionConstraints()},disable:function(){_.each(this.addButtons,function(a){a.remove()}),this.addButtons=[]},_getTypeActions:function(a){var b=this,c=[];return _.each(this.options.definition.range,function(d){var e=b.options.collection.vie.namespaces.uri(d);b.options.view.canAdd(e)&&c.push({name:d,label:d,cb:function(){b.options.collection.add({"@type":d},a)},className:"create-ui-btn"})}),c},addItem:function(c,d){d===b&&(d={});var e=_.extend({},d,{validate:!1}),f={};if(this.options.definition&&this.options.definition.range){if(1!==this.options.definition.range.length)return void a("body").midgardNotifications("create",{bindTo:c,gravity:"L",body:this.options.editableOptions.localize("Choose type to add",this.options.editableOptions.language),timeout:0,actions:this._getTypeActions(e)});f["@type"]=this.options.definition.range[0]}else{var g=_.keys(this.options.view.templates);2==g.length&&(f["@type"]=g[0])}this.options.collection.add(f,e)}})}(jQuery),function(a){"use strict";a.widget("Midgard.midgardCollectionAddBetween",a.Midgard.midgardCollectionAdd,{_bindCollectionView:function(a){var b=this;a.on("add",function(a){b._makeEditable(a),b._refreshButtons()}),a.on("remove",function(){b._refreshButtons()})},_refreshButtons:function(){var a=this;window.setTimeout(function(){a.disable(),a.enable()},1)},prepareButton:function(b){var c=this,d=a(_.template(this.options.templates.button,{icon:"plus",label:""})).button();return d.addClass("midgard-create-add"),d.click(function(){c.addItem(d,{at:b})}),d},enable:function(){var b=this,c=b.prepareButton(0);a(b.options.view.el).prepend(c),b.addButtons.push(c),a.each(b.options.view.entityViews,function(c,d){var e=b.options.collection.indexOf(d.model),f=b.prepareButton(e+1);a(d.el).append(f),b.addButtons.push(f)}),this.checkCollectionConstraints()},disable:function(){var b=this;a.each(b.addButtons,function(a,b){b.remove()}),b.addButtons=[]}})}(jQuery),function(a){"use strict";a.widget("Midgard.editWidget",{options:{disabled:!1,vie:null},enable:function(){this.element.attr("contenteditable","true")},disable:function(){this.element.attr("contenteditable","false")
},_create:function(){this._registerWidget(),this._initialize(),_.isFunction(this.options.decorate)&&_.isFunction(this.options.decorateParams)&&this.options.decorate(this.options.decorateParams(null,{propertyName:this.options.property,propertyEditor:this,propertyElement:this.element,editor:this,predicate:this.options.property,element:this.element}))},_init:function(){return this.options.disabled?void this.disable():void this.enable()},_initialize:function(){var b=this;this.element.on("focus",function(){b.options.disabled||b.options.activated()}),this.element.on("blur",function(){b.options.disabled||b.options.deactivated()});var c=this.element.text();this.element.on("keyup paste",function(){if(!b.options.disabled){var d=a(this).text();c!==d&&(c=d,b.options.changed(d))}})},_registerWidget:function(){this.element.data("createWidgetName",this.widgetName)}})}(jQuery),function(a){"use strict";a.widget("Midgard.alohaWidget",a.Midgard.editWidget,{_initialize:function(){},enable:function(){function a(){Aloha.activeEditable.isModified()&&(c.changed(Aloha.activeEditable.getContents()),Aloha.activeEditable.setUnmodified())}var b,c=this.options,d=Aloha.jQuery(c.element.get(0)).aloha();if(_.each(Aloha.editables,function(a){a.obj.get(0)===d.get(0)&&(b=a)}),b){b.vieEntity=c.entity;var e;Aloha.bind("aloha-editable-activated",function(d,f){f.editable===b&&(e=window.setInterval(a,500),c.activated())}),Aloha.bind("aloha-editable-deactivated",function(a,d){d.editable===b&&(window.clearInterval(e),c.deactivated())}),Aloha.bind("aloha-smart-content-changed",function(a,d){if(d.editable===b){if(!d.editable.isModified())return!0;c.changed(d.editable.getContents()),d.editable.setUnmodified()}}),this.options.disabled=!1}},disable:function(){Aloha.jQuery(this.options.element.get(0)).mahalo(),this.options.disabled=!0}})}(jQuery),function(a){"use strict";a.widget("Midgard.ckeditorWidget",a.Midgard.editWidget,{options:{editorOptions:{},disabled:!0,vie:null},enable:function(){this.element.attr("contentEditable","true"),this.editor=CKEDITOR.inline(this.element.get(0)),this.options.disabled=!1;var b=this;this.editor.on("focus",function(){b.options.activated()}),this.editor.on("blur",function(){b.options.activated(),b.options.changed(b.editor.getData())}),this.editor.on("change",function(){b.options.changed(b.editor.getData())}),this.editor.on("configLoaded",function(){a.each(b.options.editorOptions,function(a,c){b.editor.config[a]=c})})},disable:function(){this.editor&&(this.element.attr("contentEditable","false"),this.editor.destroy(),this.editor=null)},_initialize:function(){CKEDITOR.disableAutoInline=!0}})}(jQuery),function(a){"use strict";a.widget("Midgard.halloWidget",a.Midgard.editWidget,{options:{editorOptions:{},disabled:!0,toolbarState:"full",vie:null,entity:null},enable:function(){a(this.element).hallo({editable:!0}),this.options.disabled=!1},disable:function(){a(this.element).hallo({editable:!1}),this.options.disabled=!0},_initialize:function(){a(this.element).hallo(this.getHalloOptions());var b=this;a(this.element).on("halloactivated",function(){b.options.activated()}),a(this.element).on("hallodeactivated",function(){b.options.deactivated()}),a(this.element).on("hallomodified",function(a,c){b.options.changed(c.content),c.editable.setUnmodified()}),a(document).on("midgardtoolbarstatechange",function(a,c){if(c.display!==b.options.toolbarState&&(b.options.toolbarState=c.display,b.element.data("IKS-hallo")||b.element.data("hallo"))){var d=b.getHalloOptions();b.element.hallo("changeToolbar",d.parentElement,d.toolbar,!0)}})},getHalloOptions:function(){var b={plugins:{halloformat:{},halloblock:{},hallolists:{},hallolink:{},halloimage:{entity:this.options.entity}},buttonCssClass:"create-ui-btn-small",placeholder:"["+this.options.property+"]"};return"function"==typeof this.element.annotate&&this.options.vie.services.stanbol&&(b.plugins.halloannotate={vie:this.options.vie}),"full"===this.options.toolbarState?(b.parentElement=a(".create-ui-toolbar-dynamictoolarea .create-ui-tool-freearea"),b.toolbar="halloToolbarFixed"):(b.parentElement="body",b.toolbar="halloToolbarContextual"),_.extend(b,this.options.editorOptions)}})}(jQuery),function(a){"use strict";a.widget("Midgard.mediumWidget",a.Midgard.editWidget,{editor:null,listener:null,options:{editorOptions:{},disabled:!0},enable:function(){this.editor=new MediumEditor(this._buildSelector(),this.editorOptions),this.listener=function(){this.options.changed(a(this.element).text())}.bind(this),a(this.element).on("keyup",this.listener)},disable:function(){a(this.element).off("keyup",this.listener)},_buildSelector:function(){var a='[about="'+this.options.entity.getSubjectUri()+'"]',b='[property="'+this.options.property+'"]';return a+" "+b}})}(jQuery),function(a){"use strict";a.widget("Midgard.tinymceWidget",a.Midgard.editWidget,{enable:function(){this.element.attr("contentEditable","true");var a=this.element.attr("id");(!a||tinymce.get(a))&&(a=tinymce.DOM.uniqueId()),this.element.attr("id",a),this.editor=new tinymce.Editor(a,{inline:!0},tinymce.EditorManager),this.editor.render(!0),this.options.disabled=!1;var b=this;this.editor.on("focus",function(){b.options.activated()}),this.editor.on("blur",function(){b.options.activated(),b.options.changed(b.editor.getContent())}),this.editor.on("change",function(){b.options.changed(b.editor.getContent())})},disable:function(){this.editor&&(this.element.attr("contentEditable","false"),this.editor.remove(),this.editor=null)}})}(jQuery),function(a){"use strict";a.widget("Midgard.midgardGeo",{options:{layer:null,map:null,coordSystem:"EPSG:4326",defaultCenter:null,defaultZoomLevel:3,geoProperty:"http://schema.org/geo",geoCoordinateType:"http://schema.org/GeoCoordinates",geoLonProperty:"http://schema.org/longitude",geoLatProperty:"http://schema.org/latitude",marker:{url:"http://www.openlayers.org/dev/img/marker.png",size:{w:21,h:25},offset:{w:-10,h:-25}}},data:{},coordsObj:null,activate:function(a){this.data=a,this.coordsObj=null;var b=this.data.entity.get(this.options.geoProperty);if(_.isUndefined(b)){var c=this.data.entity.attributes["@type"];_.isArray(c)||(c=[c]),_.indexOf(c,"<"+this.options.geoCoordinateType+">")>0&&(this.coordsObj=this.data.entity)}else this.coordsObj=b.models[0];if(_.isNull(this.coordsObj))return void this.element.hide();this.element.show();var d=parseFloat(this.coordsObj.get(this.options.geoLatProperty)),e=parseFloat(this.coordsObj.get(this.options.geoLonProperty));this.centerMap(e,d)},_createMap:function(){if(_.isNull(this.options.map)){var b=this,c=a("<div>",{id:"midgardGeoMap",style:"height:200px; width:300px"});this.element.append(c),this.options.map=new OpenLayers.Map("midgardGeoMap"),_.isNull(this.options.layer)&&(this.options.layer=new OpenLayers.Layer.OSM("OSM")),this.options.map.addLayer(this.options.layer),this.options.markers=new OpenLayers.Layer.Markers("Markers"),this.options.map.addLayer(this.options.markers),OpenLayers.Control.Click=OpenLayers.Class(OpenLayers.Control,{defaultHandlerOptions:{single:!0,"double":!1,pixelTolerance:0,stopSingle:!1,stopDouble:!1},initialize:function(){this.handlerOptions=OpenLayers.Util.extend({},this.defaultHandlerOptions),OpenLayers.Control.prototype.initialize.apply(this,arguments),this.handler=new OpenLayers.Handler.Click(this,{click:function(a){b.mapClick(a)}},this.handlerOptions)}});var d=new OpenLayers.Control.Click;this.options.map.addControl(d),d.activate();var e=this.options.defaultCenter.clone();e.transform(new OpenLayers.Projection(this.options.coordSystem),this.options.map.getProjectionObject()),this.options.map.setCenter(e,this.options.defaultZoomLevel)}},mapClick:function(a){var b=this.options.map.getLonLatFromPixel(a.xy);b.transform(this.options.map.getProjectionObject(),new OpenLayers.Projection(this.options.coordSystem));var c=b.clone();this.centerMap(c.lon,c.lat),this.setCoordinates(b.lat,b.lon)},disable:function(){},setCoordinates:function(a,b){var c=this.data.entity.get(this.options.geoProperty),d=c.models[0];d.set(this.options.geoLatProperty,a),d.set(this.options.geoLonProperty,b)},_init:function(){this.element.hide(),this.element.append(a("<h3>GEO</h3>")),_.isNull(this.options.defaultCenter)&&(this.options.defaultCenter=new OpenLayers.LonLat(0,0)),this._createMap()},centerMap:function(a,b){var c=new OpenLayers.LonLat(a,b).transform(new OpenLayers.Projection(this.options.coordSystem),this.options.map.getProjectionObject());this.options.centermark&&this.options.centermark.destroy();var d=new OpenLayers.Size(this.options.marker.size.w,this.options.marker.size.h),e=new OpenLayers.Pixel(this.options.marker.offset.w,this.options.marker.offset.h),f=new OpenLayers.Icon(this.options.marker.url,d,e);this.options.centermark=new OpenLayers.Marker(c,f),this.options.markers.addMarker(this.options.centermark),this.options.map.panTo(c)}})}(jQuery),function(a,b){"use strict";a.widget("Midgard.midgardTags",{enhanced:!1,options:{predicate:"skos:related",vie:null,templates:{tags:'<div class="create-ui-tags <%= type %>Tags"><h3><%= label %></h3><input type="text" class="tags" value="" /></div>'},localize:function(a,b){return window.midgardCreate.localize(a,b)},language:null},_init:function(){this.vie=this.options.vie},activate:function(a){var b=this._render(a.entity);this.loadTags(a.entity,a.predicate,b)},_normalizeSubject:function(a){return this.vie.entities.isReference(a)?a:("http://"!==a.substr(0,7)&&(a="urn:tag:"+a),a=this.vie.entities.toReference(a))},_tagLabel:function(a){return a=this.vie.entities.fromReference(a),"urn:tag:"===a.substr(0,8)&&(a=a.substr(8,a.length-1)),"http://"==a.substring(0,7)&&(a=a.substr(a.lastIndexOf("/")+1,a.length-1),a=a.replace(/_/g," ")),a},addTag:function(a,c,d,e){d===b&&(d=this._tagLabel(c)),c=this._normalizeSubject(c);var f=a.get(this.options.predicate);if(!(f&&f.isCollection&&f.get(c))){e&&!a.isReference(e)&&(e=a.toReference(e));var g=this.vie.entities.addOrUpdate({"@subject":c,"rdfs:label":d,"@type":e});return f?void f.addOrUpdate(g):void a.set(this.options.predicate,g)}},removeTag:function(a,b){var c=a.get(this.options.predicate);if(c){b=this._normalizeSubject(b);var d=c.get(b);d&&c.remove(b)}},_listenAnnotate:function(a,b){var c=this;b.on("annotateselect",function(b,d){c.addTag(a,d.linkedEntity.uri,d.linkedEntity.label,d.linkedEntity.type[0])}),b.on("annotateremove",function(b,d){c.removeTag(a,d.linkedEntity.uri)})},_render:function(b){this.element.empty();var c=a(_.template(this.options.templates.tags,{type:"article",label:this.options.localize("Item tags",this.options.language)})),d=a(_.template(this.options.templates.tags,{type:"suggested",label:this.options.localize("Suggested tags",this.options.language)}));return a("input",c).attr("id","articleTags-"+b.cid),a("input",d).attr("id","suggestedTags-"+b.cid),this.element.append(c),this.element.append(d),this._renderInputs(b,c,d),{tags:c,suggested:d}},_renderInputs:function(b,c,d){{var e=this;b.getSubject()}c.tagsInput({width:"auto",height:"auto",onAddTag:function(a){e.addTag(b,a)},onRemoveTag:function(a){e.removeTag(b,a)},defaultText:this.options.localize("add a tag",this.options.language)});var f=function(){var c=a.trim(a(this).text());e.addTag(b,c),d.removeTag(c)};d.tagsInput({width:"auto",height:"auto",interactive:!1,onAddTag:function(){a(".tag span",d).off("click",f),a(".tag span",d).on("click",f)},onRemoveTag:function(){a(".tag span",d).off("click",f),a(".tag span",d).on("click",f)},remove:!1})},_getTagStrings:function(a){var b=[];return _.isString(a)?(b.push(a),b):a.isCollection?(a.each(function(a){b.push(a.get("rdfs:label"))}),b):(_.each(a,function(a){b.push(this._tagLabel(a))},this),b)},loadTags:function(b,c,d){var e=this,f=b.get(this.options.predicate);if(f){var g=this._getTagStrings(f);_.each(g,d.tags.addTag,d.tags)}this.vie.services.stanbol||a(".suggestedTags",e.element).hide()},_getLabelLang:function(a){if(!_.isArray(a))return null;var b;return _.each(a,function(a){"en"===a["@language"]&&(b=a["@value"])}),b},_addEnhancement:function(a,b){if(b.isEntity){var c=this._getLabelLang(b.get("rdfs:label"));if(c){var d=a.get(this.options.predicate);d&&d.isCollection&&-1!==d.indexOf(b)||this.suggestedTags.addTag(c)}}},enhance:function(b,c){if(!this.enhanced){this.enhanced=!0;var d=this;this.vie.analyze({element:a("[property]",c)}).using(["stanbol"]).execute().success(function(a){_.each(a,function(a){d._addEnhancement(b,a)})}).fail(function(){})}}})}(jQuery),void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.bg={Save:"Запази",Saving:"Запазване",Cancel:"Откажи",Edit:"Редактирай",localModification:'Елементът "<%= label %>" има локални модификации',localModifications:"<%= number %> елемента на тази страница имат локални модификации",Restore:"Възстанови",Ignore:"Игнорирай",saveSuccess:'Елементът "<%= label %>" беше успешно запазен',saveSuccessMultiple:"<%= number %> елемента бяха успешно запазени",saveError:"Възника грешка при запазване<br /><%= error %>","Item tags":"Етикети на елемента","Suggested tags":"Препоръчани етикети",Tags:"Етикети","add a tag":"добави етикет",Add:"Добави","Choose type to add":"Избери тип за добавяне"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.cs={Save:"Uložit",Saving:"Probíhá ukládání",Cancel:"Zrušit",Edit:"Upravit",localModification:'Blok "<%= label %>" obsahuje lokální změny',localModifications:"<%= number %> bloků na této stránce má lokální změny",Restore:"Aplikovat lokální změny",Ignore:"Zahodit lokální změny",saveSuccess:'Blok "<%= label %>" byl úspěšně uložen',saveSuccessMultiple:"<%= number %> bloků bylo úspěšně uloženo",saveError:"Při ukládání došlo k chybě<br /><%= error %>","Item tags":"Štítky bloku","Suggested tags":"Navrhované štítky",Tags:"Štítky","add a tag":"Přidat štítek",Add:"Přidat","Choose type to add":"Vyberte typ k přidání"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.da={Save:"Gem",Saving:"Gemmer",Cancel:"Annullér",Edit:"Rediger",localModification:'Element "<%= label %>" har lokale ændringer',localModifications:"<%= number %> elementer på denne side har lokale ændringer",Restore:"Gendan",Ignore:"Ignorer",saveSuccess:'Element "<%= label %>" er gemt',saveSuccessMultiple:"<%= number %> elementer er gemt",saveError:"Der opstod en fejl under lagring<br /><%= error %>","Item tags":"Element tags","Suggested tags":"Foreslåede tags",Tags:"Tags","add a tag":"tilføj et tag",Add:"Tilføj","Choose type to add":"Vælg type der skal tilføjes"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.de={Save:"Speichern",Saving:"Speichert",Cancel:"Abbrechen",Edit:"Bearbeiten",localModification:'Das Dokument "<%= label %>" auf dieser Seite hat lokale Änderungen',localModifications:"<%= number %> Dokumente auf dieser Seite haben lokale Änderungen",Restore:"Wiederherstellen",Ignore:"Ignorieren",saveSuccess:'Dokument "<%= label %>" erfolgreich gespeichert',saveSuccessMultiple:"<%= number %> Dokumente erfolgreich gespeichert",saveError:"Fehler beim Speichern<br /><%= error %>","Item tags":"Schlagwörter des Dokuments","Suggested tags":"Schlagwortvorschläge",Tags:"Schlagwörter","add a tag":"Neues Schlagwort",Add:"Hinzufügen","Choose type to add":"Typ zum Hinzufügen wählen"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.en={Save:"Save",Saving:"Saving",Cancel:"Cancel",Edit:"Edit",localModification:'Item "<%= label %>" has local modifications',localModifications:"<%= number %> items on this page have local modifications",Restore:"Restore",Ignore:"Ignore",saveSuccess:'Item "<%= label %>" saved successfully',saveSuccessMultiple:"<%= number %> items saved successfully",saveError:"Error occurred while saving<br /><%= error %>","Item tags":"Item tags","Suggested tags":"Suggested tags",Tags:"Tags","add a tag":"add a tag",Add:"Add","Choose type to add":"Choose type to add"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.es={Save:"Guardar",Saving:"Guardando",Cancel:"Cancelar",Edit:"Editar",localModification:'El elemento "<%= label %>" tiene modificaciones locales',localModifications:"<%= number %> elementos en la página tienen modificaciones locales",Restore:"Restaurar",Ignore:"Ignorar",saveSuccess:'El elemento "<%= label %>" se guardó exitosamente',saveSuccessMultiple:"<%= number %> elementos se guardaron exitosamente",saveError:"Ha ocurrido un error cuando se guardaban los datos<br /><%= error %>","Item tags":"Etiquetas de los elementos","Suggested tags":"Etiquetas sugeridas",Tags:"Etiquetas","add a tag":"añadir una etiqueta",Add:"Añadir","Choose type to add":"Escoge el tipo a añadir"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.fi={Save:"Tallenna",Saving:"Tallennetaan",Cancel:"Peruuta",Edit:"Muokkaa",localModification:'Dokumentilla "<%= label %>" on paikallisia muutoksia',localModifications:"<%= number %> dokumenttia sivulla omaa paikallisia muutoksia",Restore:"Palauta",Ignore:"Poista",saveSuccess:'Dokumentti "<%= label %>" tallennettu',saveSuccessMultiple:"<%= number %> dokumenttia tallennettu",saveError:"Virhe tallennettaessa<br /><%= error %>","Item tags":"Avainsanat","Suggested tags":"Ehdotukset",Tags:"Avainsanat","add a tag":"lisää avainsana",Add:"Lisää","Choose type to add":"Mitä haluat lisätä?"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.fr={Save:"Enregistrer",Saving:"Enregistrement en cours",Cancel:"Annuler",Edit:"Éditer",localModification:'L\'élément "<%= label %>" comporte des modifications locales',localModifications:"<%= number %> éléments sur cette page comportent des modifications locales",Restore:"Restaurer",Ignore:"Ignorer",saveSuccess:'L\'élément "<%= label %>" a été enregistré avec succès',saveSuccessMultiple:"<%= number %> éléments ont été enregistrés avec succès",saveError:"Une erreur est survenue durant l'enregistrement<br /><%= error %>","Item tags":"Tags des éléments","Suggested tags":"Tags suggérés",Tags:"Tags","add a tag":"ajouter un tag",Add:"Ajouter","Choose type to add":"Choisir le type à ajouter"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.he={Save:"שמור",Saving:"שומר",Cancel:"בטל",Edit:"ערוך",localModification:'לפריט "<%= label %>" שינויים מקומיים',localModifications:"ל<%= number %> פריטים בדף זה שינויים מקומיים",Restore:"שחזר",Ignore:"התעלם",saveSuccess:'פריט "<%= label %>" נשמר בהצלחה',saveSuccessMultiple:"<%= number %> פריטים נשמרו בהצלחה",saveError:"שגיאה בשמירה<br /><%= error %>","Item tags":"סיווגי פריט","Suggested tags":"סיווגים מומלצים",Tags:"סיווגים","add a tag":"הוסף סיווג",Add:"הוסף","Choose type to add":"בחר סוג להוספה"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.it={Save:"Salva",Saving:"Salvataggio",Cancel:"Esci",Edit:"Modifica",localModification:'Articolo "<%= label %>" in questa pagina hanno modifiche locali',localModifications:"<%= number %> articoli in questa pagina hanno modifiche locali",Restore:"Ripristina",Ignore:"Ignora",saveSuccess:'Articolo "<%= label %>" salvato con successo',saveSuccessMultiple:"<%= number %> articoli salvati con successo",saveError:"Errore durante il salvataggio<br /><%= error %>","Item tags":"Tags articolo","Suggested tags":"Tags suggerite",Tags:"Tags","add a tag":"Aggiungi una parola chiave",Add:"Aggiungi","Choose type to add":"Scegli il tipo da aggiungere"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.nl={Save:"Opslaan",Saving:"Bezig met opslaan",Cancel:"Annuleren",Edit:"Bewerken",localModification:'Items "<%= label %>" op de pagina heeft lokale wijzigingen',localModifications:"<%= number %> items op de pagina hebben lokale wijzigingen",Restore:"Herstellen",Ignore:"Negeren",saveSuccess:'Item "<%= label %>" succesvol opgeslagen',saveSuccessMultiple:"<%= number %> items succesvol opgeslagen",saveError:"Fout opgetreden bij het opslaan<br /><%= error %>","Item tags":"Item tags","Suggested tags":"Tag suggesties",Tags:"Tags","add a tag":"tag toevoegen",Add:"Toevoegen","Choose type to add":"Kies type om toe te voegen"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.no={Save:"Lagre",Saving:"Lagrer",Cancel:"Avbryt",Edit:"Rediger",localModification:'Element "<%= label %>" på denne siden er modifisert lokalt',localModifications:"<%= number %> elementer på denne siden er modifisert lokalt",Restore:"Gjenopprett",Ignore:"Ignorer",saveSuccess:'Element "<%= label %>" ble lagret',saveSuccessMultiple:"<%= number %> elementer ble lagret",saveError:"En feil oppstod under lagring<br /><%= error %>","Item tags":"Element-tagger","Suggested tags":"Anbefalte tagger",Tags:"Tagger","add a tag":"legg til tagg",Add:"Legg til","Choose type to add":"Velg type å legge til"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.pl={Save:"Zapisz",Saving:"Zapisuję",Cancel:"Anuluj",Edit:"Edytuj",localModification:'Artykuł "<%= label %>" posiada lokalne modyfikacje',localModifications:"<%= number %> artykułów na tej stronie posiada lokalne modyfikacje",Restore:"Przywróć",Ignore:"Ignoruj",saveSuccess:'Artykuł "<%= label %>" został poprawnie zapisany',saveSuccessMultiple:"<%= number %> artykułów zostało poprawnie zapisanych",saveError:"Wystąpił błąd podczas zapisywania<br /><%= error %>","Item tags":"Tagi artykułów","Suggested tags":"Sugerowane tagi",Tags:"Tagi","add a tag":"dodaj tag",Add:"Dodaj","Choose type to add":"Wybierz typ do dodania"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.pt_BR={Save:"Salvar",Saving:"Salvando",Cancel:"Cancelar",Edit:"Editar",localModification:'Item "<%= label %>" nesta página possuem modificações locais',localModifications:"<%= number %> itens nesta página possuem modificações locais",Restore:"Restaurar",Ignore:"Ignorar",saveSuccess:'Item "<%= label %>" salvo com sucesso',saveSuccessMultiple:"<%= number %> itens salvos com sucesso",saveError:"Erro ocorrido ao salvar<br /><%= error %>","Item tags":"Tags de item","Suggested tags":"Tags sugeridas",Tags:"Tags","add a tag":"adicionar uma tag",Add:"Adicionar","Choose type to add":"Selecione o tipo para adicionar"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.ro={Save:"Salvează",Saving:"Se salvează",Cancel:"Anulează",Edit:"Editare",localModification:'Zona "<%= label %>" a fost modificată',localModifications:"<%= number %> zone din această pagină au fost modificate",Restore:"Revenire",Ignore:"Ignoră",saveSuccess:'Zona "<%= label %>" a fost salvată',saveSuccessMultiple:"<%= number %> zone au fost salvate",saveError:"S-a produs o eroare în timpul salvării<br /><%= error %>","Item tags":"Etichetele zonei","Suggested tags":"Etichete sugerate",Tags:"Etichete","add a tag":"adaugă o etichetă",Add:"Adăugare","Choose type to add":"Alegeți un tip pentru adăugare"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.ru={Save:"Сохранить",Saving:"Сохраняю",Cancel:"Отмена",Edit:"Редактировать",localModification:'В запись "<%= label %>" внесены несохранённые изменения',localModifications:"В записи на этой странице (<%= number %> шт.) внесены несохранённые изменения",Restore:"Восстановить",Ignore:"Игнорировать",saveSuccess:'Запись "<%= label %>" была успешно сохранена',saveSuccessMultiple:" Записи (<%= number %> шт.) были успешно сохранены",saveError:"Во время сохранения произошла ошибка<br /><%= error %>","Item tags":"Теги записей","Suggested tags":"Предлагаемые теги",Tags:"Теги","add a tag":"добавить тег",Add:"Добавить","Choose type to add":"Выбрать тип для добавления"},void 0===window.midgardCreate&&(window.midgardCreate={}),void 0===window.midgardCreate.locale&&(window.midgardCreate.locale={}),window.midgardCreate.locale.sv={Save:"Spara",Saving:"Sparar",Cancel:"Avbryt",Edit:"Redigera",localModification:'Elementet "<%= label %>" har lokala förändringar',localModifications:"<%= number %> element på den här sidan har lokala förändringar",Restore:"Återställ",Ignore:"Ignorera",saveSuccess:'Elementet "<%= label %>" sparades',saveSuccessMultiple:"<%= number %> element sparades",saveError:"Ett fel uppstod under sparande<br /><%= error %>","Item tags":"Element-taggar","Suggested tags":"Föreslagna taggar",Tags:"Taggar","add a tag":"lägg till en tagg",Add:"Lägg till","Choose type to add":"Välj typ att lägga till"};