<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\DBAL\Migrations\AbstractMigration;
use Doctrine\DBAL\Platforms\MySQL57Platform;
use Doctrine\DBAL\Schema\Schema;

class Version20171206140453 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return 'Add index that should exist but is not picked up by Doctrine, and thus was deleted by accident in 20170110130253.';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('CREATE INDEX documentnodeidentifier ON neos_neos_eventlog_domain_model_event (documentnodeidentifier)');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('DROP INDEX documentnodeidentifier ON neos_neos_eventlog_domain_model_event');
    }
}
