<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs! This block will be used as the migration description if getDescription() is not used.
 */
class Version20190626085557 extends AbstractMigration
{

    /**
     * @return string
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');
        
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_address (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) DEFAULT NULL, firstname VARCHAR(255) DEFAULT NULL, lastname VARCHAR(255) DEFAULT NULL, street VARCHAR(255) DEFAULT NULL, zip VARCHAR(255) DEFAULT NULL, city VARCHAR(255) DEFAULT NULL, country VARCHAR(255) DEFAULT NULL, phonenumber VARCHAR(255) DEFAULT NULL, emailaddress VARCHAR(255) DEFAULT NULL, websiteaddress LONGTEXT DEFAULT NULL, latitude DOUBLE PRECISION DEFAULT NULL, longitude DOUBLE PRECISION DEFAULT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_address_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier VARCHAR(40) NOT NULL, mainaddress VARCHAR(40) DEFAULT NULL, maintype INT NOT NULL, name VARCHAR(255) NOT NULL, abstract LONGTEXT DEFAULT NULL, description LONGTEXT DEFAULT NULL, facebookuri VARCHAR(255) DEFAULT NULL, twitteruri VARCHAR(255) DEFAULT NULL, instagramuri VARCHAR(255) DEFAULT NULL, youtubeuri VARCHAR(255) DEFAULT NULL, flickruri VARCHAR(255) DEFAULT NULL, wikipediauri VARCHAR(255) DEFAULT NULL, sourcename VARCHAR(255) DEFAULT NULL, authorname VARCHAR(255) DEFAULT NULL, bookinguri VARCHAR(255) DEFAULT NULL, client VARCHAR(255) DEFAULT NULL, detailuri VARCHAR(255) DEFAULT NULL, starclassification SMALLINT DEFAULT NULL, averagerating SMALLINT DEFAULT NULL, numberofratings SMALLINT DEFAULT NULL, updatedat DATETIME DEFAULT NULL, openingtimes LONGTEXT DEFAULT NULL, openingtimesformat VARCHAR(255) DEFAULT NULL, originalid VARCHAR(50) NOT NULL, relationsorting LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', language CHAR(2) DEFAULT NULL, urlidentifier VARCHAR(10) DEFAULT NULL, UNIQUE INDEX UNIQ_2D54DF93AEB4799D (urlidentifier), INDEX IDX_2D54DF936B613014 (mainaddress), INDEX newland_toubiz_sync_neos_article_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_article_addresses_join (neos_article VARCHAR(40) NOT NULL, neos_address VARCHAR(40) NOT NULL, INDEX IDX_C2F8B1C461A7D39C (neos_article), INDEX IDX_C2F8B1C46ED3B27B (neos_address), PRIMARY KEY(neos_article, neos_address)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_article_categories_join (neos_article VARCHAR(40) NOT NULL, neos_category VARCHAR(40) NOT NULL, INDEX IDX_40F8B83C61A7D39C (neos_article), INDEX IDX_40F8B83C5B479F1E (neos_category), PRIMARY KEY(neos_article, neos_category)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_article_media_join (neos_article VARCHAR(40) NOT NULL, neos_medium VARCHAR(40) NOT NULL, INDEX IDX_2B4FD31061A7D39C (neos_article), INDEX IDX_2B4FD3105DC266AA (neos_medium), PRIMARY KEY(neos_article, neos_medium)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_article_files_join (neos_article VARCHAR(40) NOT NULL, neos_file VARCHAR(40) NOT NULL, INDEX IDX_6FC009A261A7D39C (neos_article), INDEX IDX_6FC009A2D731232 (neos_file), PRIMARY KEY(neos_article, neos_file)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_attribute (persistence_object_identifier VARCHAR(40) NOT NULL, article VARCHAR(40) DEFAULT NULL, name VARCHAR(255) NOT NULL, data LONGTEXT DEFAULT NULL, type VARCHAR(10) DEFAULT NULL, identificationhash VARCHAR(32) DEFAULT NULL, INDEX IDX_6265372F23A0E66 (article), INDEX identificationHash (identificationHash), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_benefit (persistence_object_identifier VARCHAR(40) NOT NULL, package VARCHAR(40) DEFAULT NULL, name VARCHAR(255) NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX IDX_73E5D1EADE686795 (package), INDEX newland_toubiz_sync_neos_benefit_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_category (persistence_object_identifier VARCHAR(40) NOT NULL, title VARCHAR(255) NOT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, INDEX newland_toubiz_sync_neos_category_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_event (persistence_object_identifier VARCHAR(40) NOT NULL, location VARCHAR(40) DEFAULT NULL, organizer VARCHAR(40) DEFAULT NULL, title VARCHAR(255) NOT NULL, description LONGTEXT DEFAULT NULL, additionalinformation LONGTEXT DEFAULT NULL, admission LONGTEXT DEFAULT NULL, ishighlight TINYINT(1) NOT NULL, istipp TINYINT(1) NOT NULL, beginsat DATETIME NOT NULL, endsat DATETIME NOT NULL, ticketuri LONGTEXT DEFAULT NULL, ticketcontact LONGTEXT DEFAULT NULL, link LONGTEXT DEFAULT NULL, updatedat DATETIME NOT NULL, sourcename VARCHAR(255) DEFAULT NULL, attributes LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', scope SMALLINT DEFAULT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, urlidentifier VARCHAR(10) DEFAULT NULL, UNIQUE INDEX UNIQ_4DAD30E6AEB4799D (urlidentifier), INDEX IDX_4DAD30E65E9E89CB (location), INDEX IDX_4DAD30E699D47173 (organizer), INDEX newland_toubiz_sync_neos_event_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_event_categories_join (neos_event VARCHAR(40) NOT NULL, neos_category VARCHAR(40) NOT NULL, INDEX IDX_744FD94FEE4FA767 (neos_event), INDEX IDX_744FD94F5B479F1E (neos_category), PRIMARY KEY(neos_event, neos_category)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_event_eventtags_join (neos_event VARCHAR(40) NOT NULL, neos_eventtag VARCHAR(40) NOT NULL, INDEX IDX_ECF21824EE4FA767 (neos_event), INDEX IDX_ECF2182449341CE7 (neos_eventtag), PRIMARY KEY(neos_event, neos_eventtag)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_event_media_join (neos_event VARCHAR(40) NOT NULL, neos_medium VARCHAR(40) NOT NULL, INDEX IDX_886DAE27EE4FA767 (neos_event), INDEX IDX_886DAE275DC266AA (neos_medium), PRIMARY KEY(neos_event, neos_medium)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_eventdate (persistence_object_identifier VARCHAR(40) NOT NULL, event VARCHAR(40) DEFAULT NULL, beginsat DATETIME NOT NULL, endsat DATETIME NOT NULL, note VARCHAR(255) NOT NULL, detailuri VARCHAR(255) DEFAULT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, INDEX IDX_6E2533873BAE0AA7 (event), INDEX newland_toubiz_sync_neos_eventdate_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_eventtag (persistence_object_identifier VARCHAR(40) NOT NULL, keyword LONGTEXT NOT NULL, originalid VARCHAR(50) NOT NULL, language CHAR(2) DEFAULT NULL, INDEX newland_toubiz_sync_neos_eventtag_import_ident (language, originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_file (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, sourceuri LONGTEXT NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_file_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_geometry (persistence_object_identifier VARCHAR(40) NOT NULL, type VARCHAR(255) NOT NULL, label VARCHAR(255) NOT NULL, geometry GEOMETRY NOT NULL COMMENT \'(DC2Type:geometry)\', PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_keyvalue (persistence_object_identifier VARCHAR(40) NOT NULL, identifier VARCHAR(255) NOT NULL, data LONGTEXT NOT NULL, INDEX newland_toubiz_sync_neos_keyvalue_identifier (identifier), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier VARCHAR(40) NOT NULL, title LONGTEXT DEFAULT NULL, sourceuri LONGTEXT NOT NULL, copyright VARCHAR(255) DEFAULT NULL, sorting INT DEFAULT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_medium_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_offer (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, previewimage VARCHAR(255) DEFAULT NULL, startingprice DOUBLE PRECISION DEFAULT NULL, startingpricecurrency CHAR(3) DEFAULT NULL, durationminutes INT DEFAULT NULL, address VARCHAR(255) DEFAULT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_offer_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_package (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, minimumnights DOUBLE PRECISION DEFAULT NULL, startingprice DOUBLE PRECISION DEFAULT NULL, startingpricecurrency CHAR(3) DEFAULT NULL, client VARCHAR(255) NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_package_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_package_media_join (neos_package VARCHAR(40) NOT NULL, neos_medium VARCHAR(40) NOT NULL, INDEX IDX_1B8AF764BDF5BA6F (neos_package), INDEX IDX_1B8AF7645DC266AA (neos_medium), PRIMARY KEY(neos_package, neos_medium)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_region (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, attributes LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', updatedat DATETIME DEFAULT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_region_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_region_transportation_facilities_join (neos_region VARCHAR(40) NOT NULL, neos_transportationfacility VARCHAR(40) NOT NULL, INDEX IDX_3349FAD194D3D26B (neos_region), INDEX IDX_3349FAD1E580DEF8 (neos_transportationfacility), PRIMARY KEY(neos_region, neos_transportationfacility)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_region_slopes_join (neos_region VARCHAR(40) NOT NULL, neos_slope VARCHAR(40) NOT NULL, INDEX IDX_9603E59694D3D26B (neos_region), INDEX IDX_9603E5968D2DE845 (neos_slope), PRIMARY KEY(neos_region, neos_slope)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_slope (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, status INT NOT NULL, type INT DEFAULT NULL, difficulty INT DEFAULT NULL, updatedat DATETIME NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_slope_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE newland_toubiz_sync_neos_domain_model_transportationfacility (persistence_object_identifier VARCHAR(40) NOT NULL, name VARCHAR(255) NOT NULL, type INT NOT NULL, status INT NOT NULL, length INT DEFAULT NULL, traveltime INT DEFAULT NULL, updatedat DATETIME NOT NULL, originalid VARCHAR(50) NOT NULL, INDEX newland_toubiz_sync_neos_transportationfacility_import_ident (originalid), PRIMARY KEY(persistence_object_identifier)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article ADD CONSTRAINT FK_2D54DF936B613014 FOREIGN KEY (mainaddress) REFERENCES newland_toubiz_sync_neos_domain_model_address (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_addresses_join ADD CONSTRAINT FK_C2F8B1C461A7D39C FOREIGN KEY (neos_article) REFERENCES newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_addresses_join ADD CONSTRAINT FK_C2F8B1C46ED3B27B FOREIGN KEY (neos_address) REFERENCES newland_toubiz_sync_neos_domain_model_address (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_categories_join ADD CONSTRAINT FK_40F8B83C61A7D39C FOREIGN KEY (neos_article) REFERENCES newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_categories_join ADD CONSTRAINT FK_40F8B83C5B479F1E FOREIGN KEY (neos_category) REFERENCES newland_toubiz_sync_neos_domain_model_category (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_media_join ADD CONSTRAINT FK_2B4FD31061A7D39C FOREIGN KEY (neos_article) REFERENCES newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_media_join ADD CONSTRAINT FK_2B4FD3105DC266AA FOREIGN KEY (neos_medium) REFERENCES newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_files_join ADD CONSTRAINT FK_6FC009A261A7D39C FOREIGN KEY (neos_article) REFERENCES newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_files_join ADD CONSTRAINT FK_6FC009A2D731232 FOREIGN KEY (neos_file) REFERENCES newland_toubiz_sync_neos_domain_model_file (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_attribute ADD CONSTRAINT FK_6265372F23A0E66 FOREIGN KEY (article) REFERENCES newland_toubiz_sync_neos_domain_model_article (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_benefit ADD CONSTRAINT FK_73E5D1EADE686795 FOREIGN KEY (package) REFERENCES newland_toubiz_sync_neos_domain_model_package (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event ADD CONSTRAINT FK_4DAD30E65E9E89CB FOREIGN KEY (location) REFERENCES newland_toubiz_sync_neos_domain_model_address (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event ADD CONSTRAINT FK_4DAD30E699D47173 FOREIGN KEY (organizer) REFERENCES newland_toubiz_sync_neos_domain_model_address (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_categories_join ADD CONSTRAINT FK_744FD94FEE4FA767 FOREIGN KEY (neos_event) REFERENCES newland_toubiz_sync_neos_domain_model_event (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_categories_join ADD CONSTRAINT FK_744FD94F5B479F1E FOREIGN KEY (neos_category) REFERENCES newland_toubiz_sync_neos_domain_model_category (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_eventtags_join ADD CONSTRAINT FK_ECF21824EE4FA767 FOREIGN KEY (neos_event) REFERENCES newland_toubiz_sync_neos_domain_model_event (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_eventtags_join ADD CONSTRAINT FK_ECF2182449341CE7 FOREIGN KEY (neos_eventtag) REFERENCES newland_toubiz_sync_neos_domain_model_eventtag (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_media_join ADD CONSTRAINT FK_886DAE27EE4FA767 FOREIGN KEY (neos_event) REFERENCES newland_toubiz_sync_neos_domain_model_event (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_media_join ADD CONSTRAINT FK_886DAE275DC266AA FOREIGN KEY (neos_medium) REFERENCES newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_eventdate ADD CONSTRAINT FK_6E2533873BAE0AA7 FOREIGN KEY (event) REFERENCES newland_toubiz_sync_neos_domain_model_event (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package_media_join ADD CONSTRAINT FK_1B8AF764BDF5BA6F FOREIGN KEY (neos_package) REFERENCES newland_toubiz_sync_neos_domain_model_package (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package_media_join ADD CONSTRAINT FK_1B8AF7645DC266AA FOREIGN KEY (neos_medium) REFERENCES newland_toubiz_sync_neos_domain_model_medium (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_transportation_facilities_join ADD CONSTRAINT FK_3349FAD194D3D26B FOREIGN KEY (neos_region) REFERENCES newland_toubiz_sync_neos_domain_model_region (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_transportation_facilities_join ADD CONSTRAINT FK_3349FAD1E580DEF8 FOREIGN KEY (neos_transportationfacility) REFERENCES newland_toubiz_sync_neos_domain_model_transportationfacility (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_slopes_join ADD CONSTRAINT FK_9603E59694D3D26B FOREIGN KEY (neos_region) REFERENCES newland_toubiz_sync_neos_domain_model_region (persistence_object_identifier)');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_slopes_join ADD CONSTRAINT FK_9603E5968D2DE845 FOREIGN KEY (neos_slope) REFERENCES newland_toubiz_sync_neos_domain_model_slope (persistence_object_identifier)');
        $this->addSql('ALTER TABLE neos_contentrepository_domain_model_nodedata DROP INDEX IDX_CE6515692D45FE4D, ADD UNIQUE INDEX UNIQ_CE6515692D45FE4D (movedto)');
        $this->addSql('DROP INDEX idx_35dc14f03332102a ON neos_flow_resourcemanagement_persistentresource');
        $this->addSql('CREATE INDEX IDX_6954B1F63332102A ON neos_flow_resourcemanagement_persistentresource (sha1)');
        $this->addSql('ALTER TABLE neos_media_domain_model_asset CHANGE assetsourceidentifier assetsourceidentifier VARCHAR(255) NOT NULL');
        $this->addSql('ALTER TABLE neos_media_domain_model_importedasset CHANGE importedat importedat DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\'');
        $this->addSql('DROP INDEX sourceuripathhash ON neos_redirecthandler_databasestorage_domain_model_redirect');
        $this->addSql('ALTER TABLE newland_toubiz_search_neos_domain_model_history_searchquery ADD scopes LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', DROP scope');
        $this->addSql('ALTER TABLE newland_toubiz_search_neos_domain_model_searchindex CHANGE source source VARCHAR(255) DEFAULT NULL');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        // this down() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');
        
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article DROP FOREIGN KEY FK_2D54DF936B613014');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_addresses_join DROP FOREIGN KEY FK_C2F8B1C46ED3B27B');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event DROP FOREIGN KEY FK_4DAD30E65E9E89CB');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event DROP FOREIGN KEY FK_4DAD30E699D47173');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_addresses_join DROP FOREIGN KEY FK_C2F8B1C461A7D39C');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_categories_join DROP FOREIGN KEY FK_40F8B83C61A7D39C');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_media_join DROP FOREIGN KEY FK_2B4FD31061A7D39C');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_files_join DROP FOREIGN KEY FK_6FC009A261A7D39C');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_attribute DROP FOREIGN KEY FK_6265372F23A0E66');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_categories_join DROP FOREIGN KEY FK_40F8B83C5B479F1E');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_categories_join DROP FOREIGN KEY FK_744FD94F5B479F1E');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_categories_join DROP FOREIGN KEY FK_744FD94FEE4FA767');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_eventtags_join DROP FOREIGN KEY FK_ECF21824EE4FA767');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_media_join DROP FOREIGN KEY FK_886DAE27EE4FA767');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_eventdate DROP FOREIGN KEY FK_6E2533873BAE0AA7');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_eventtags_join DROP FOREIGN KEY FK_ECF2182449341CE7');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_files_join DROP FOREIGN KEY FK_6FC009A2D731232');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_media_join DROP FOREIGN KEY FK_2B4FD3105DC266AA');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_media_join DROP FOREIGN KEY FK_886DAE275DC266AA');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package_media_join DROP FOREIGN KEY FK_1B8AF7645DC266AA');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_benefit DROP FOREIGN KEY FK_73E5D1EADE686795');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package_media_join DROP FOREIGN KEY FK_1B8AF764BDF5BA6F');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_transportation_facilities_join DROP FOREIGN KEY FK_3349FAD194D3D26B');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_slopes_join DROP FOREIGN KEY FK_9603E59694D3D26B');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_slopes_join DROP FOREIGN KEY FK_9603E5968D2DE845');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_transportation_facilities_join DROP FOREIGN KEY FK_3349FAD1E580DEF8');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_address');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_article');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_article_addresses_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_article_categories_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_article_media_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_article_files_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_attribute');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_benefit');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_category');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_event');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_event_categories_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_event_eventtags_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_event_media_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_eventdate');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_eventtag');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_file');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_geometry');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_keyvalue');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_medium');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_offer');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_package');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_package_media_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_region');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_region_transportation_facilities_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_region_slopes_join');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_slope');
        $this->addSql('DROP TABLE newland_toubiz_sync_neos_domain_model_transportationfacility');
        $this->addSql('ALTER TABLE neos_contentrepository_domain_model_nodedata DROP INDEX UNIQ_CE6515692D45FE4D, ADD INDEX IDX_CE6515692D45FE4D (movedto)');
        $this->addSql('DROP INDEX idx_6954b1f63332102a ON neos_flow_resourcemanagement_persistentresource');
        $this->addSql('CREATE INDEX IDX_35DC14F03332102A ON neos_flow_resourcemanagement_persistentresource (sha1)');
        $this->addSql('ALTER TABLE neos_media_domain_model_asset CHANGE assetsourceidentifier assetsourceidentifier VARCHAR(255) DEFAULT \'neos\' COLLATE utf8mb4_unicode_ci');
        $this->addSql('ALTER TABLE neos_media_domain_model_importedasset CHANGE importedat importedat DATETIME NOT NULL');
        $this->addSql('CREATE INDEX sourceuripathhash ON neos_redirecthandler_databasestorage_domain_model_redirect (sourceuripathhash, host)');
        $this->addSql('ALTER TABLE newland_toubiz_search_neos_domain_model_history_searchquery ADD scope VARCHAR(255) DEFAULT NULL COLLATE utf8mb4_unicode_ci, DROP scopes');
        $this->addSql('ALTER TABLE newland_toubiz_search_neos_domain_model_searchindex CHANGE source source VARCHAR(255) NOT NULL COLLATE utf8mb4_unicode_ci');
    }
}