const path = require('path');
const webpack = require('webpack');
const VueLoaderPlugin = require('vue-loader/lib/plugin');

/*
 *  Webpack configuration object.
 *  See https://webpack.js.org/configuration/ for
 *  available settings.
 */
module.exports = {
    mode: process.env.NODE_ENV ? process.env.NODE_ENV : 'production',
    optimization: {
        minimize: process.env.NODE_ENV && process.env.NODE_ENV == 'production',
    },
    entry: {
        main: './Resources/Private/Javascript/main.js',
        sitetracking: './Resources/Private/Javascript/site-tracking.js',
    },
    output: {
        /*
         *  See https://github.com/neos/neos-development-collection/issues/2104
         *  for why we need to set a library key here. Can be some string.
         */
        library: 'LIS',
        libraryTarget: 'umd',

        // Path where the bundled outputs will be placed.
        path: path.resolve(__dirname, './Resources/Public/Scripts'),

        /*
         *  Split the output in chunks which will be loaded via
         *  dynamic imports.
         *  https://webpack.js.org/guides/code-splitting/#dynamic-imports
         */
        chunkFilename: '[name].chunk.js',
        filename: '[name].js',

        // Path from which chunks will be loaded.
        publicPath: `/_Resources/Static/Packages/Newland.CityTheme/Scripts/`,
    },
    resolve: {
        extensions: [ '.js' ],
    },
    plugins: [
        /*
         *  Example for loading only `moment/locale/de.js` and `moment/locale/en.js`,
         *  not all locales which would take up a lot of space.
         */
        new webpack.ContextReplacementPlugin(/moment[/\\]locale$/, /de|en/),

        /*
         *  Order the modules and chunks by occurrence. This saves space,
         *  because often referenced modules and chunks get smaller ids.
         */
        new webpack.optimize.OccurrenceOrderPlugin(),
        new VueLoaderPlugin(),
    ],
    module: {
        rules: [
            {
                enforce: 'pre',
                test: /\.(js)$/,
                exclude: /(node_modules|packages|Packages\/Plugins)/,
                use: 'eslint-loader',
            }, {
                test: /\.js$/,
                /*
                *  Exclude node_modules but make sure to include
                *  those which are written in ES6, like @nimius ones
                *  or swiper.
                */
                exclude: /(node_modules(?!\/(@nimius|@newland|swiper|dom7)))/,
                use: 'babel-loader',
            }, {
                test: /\.svg$/,
                use: 'string-loader',
            }, {
                test: /(\.jpg|\.png)$/,
                loader: ['file-loader'],
            }, {
                test: /\.css$/,
                loader: [ 'style-loader', 'css-loader' ],
            }, {
                test: /(\.jpg|\.png)$/,
                loader: [ 'file-loader' ],
            }, {
                test: /\.(vue)$/,
                loader: [ 'vue-loader' ],
            },
        ],
    },
};
