(window["webpackJsonpLIS"] = window["webpackJsonpLIS"] || []).push([["toubiz-range-slider"],{

/***/ "../../Plugins/Newland.AssetsNeos/Scripts/toubiz-range-slider/index.js":
/*!**************************************************************************************************************!*\
  !*** /Users/Nicki/Sites/toubiz-ort/Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-range-slider/index.js ***!
  \**************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return ToubizRangeSlider; });\n/* harmony import */ var nouislider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! nouislider */ \"../../Plugins/Newland.AssetsNeos/node_modules/nouislider/distribute/nouislider.js\");\n/* harmony import */ var nouislider__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(nouislider__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _nimius_dom_utility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @nimius/dom-utility */ \"../../Plugins/Newland.AssetsNeos/node_modules/@nimius/dom-utility/index.js\");\n/* harmony import */ var _nimius_event_utility__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @nimius/event-utility */ \"../../Plugins/Newland.AssetsNeos/node_modules/@nimius/event-utility/index.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _iterableToArrayLimit(arr, i) { if (typeof Symbol === \"undefined\" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && Symbol.iterator in Object(iter)) return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\n\nfunction _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === \"undefined\" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\n\n\n\n/**\n * @typedef {object} ToubizRangeSlider~options\n * @property {object} userField\n * @property {string} userField.min\n * @property {string} userField.max\n * @property {object} bounds\n * @property {number} bounds.min\n * @property {number} bounds.max\n * @property {object} dataField\n * @property {string} [dataField.min]\n * @property {string} [dataField.max]\n * @property {number} [factor]\n * @property {number} [step]\n * @property {string} [decimals]\n * @property {string} [roundFactor]\n * @property {string} [changeEvent]\n */\n\n/**\n * @typedef {object} ToubizRangeSlider~state\n * @property {number} min\n * @property {number} max\n */\n\n/**\n * The example below shows a range-slider with two mandatory input elements\n * defined by 'data-toubiz-range-slider-input.<min / max>' (#target-input-min, #target-input-max)\n * and some optional outputs defined by 'data-toubiz-range-slider-outputs.<min / max>'\n * (#target-output-min__1, #target-output-min__2, #target-output-max).\n *\n * Two additional options may be set:\n *  factor - This will ONLY scale the displayed value of output elements by the given amount. The factor is\n *           the number to multiply a real data value with to get a display value.\n *  step -  With step two things are done. First, the jump interval of the handles are set.\n *          Secondly, it sets the number of decimals the number has to fit the step size in.\n *\n * @example\n * <div>\n *      <div\n *          data-toubiz-range-slider\n *          data-toubiz-range-slider-user-field.min=\"#target-input-min\"\n *          data-toubiz-range-slider-user-field.max=\"#target-input-max\"\n *          data-toubiz-range-slider-data-field.min=\"#target-output-min__1, #target-output-min__2\"\n *          data-toubiz-range-slider-data-field.max=\"#target-output-max\"\n *          data-toubiz-range-slider-factor=\"(double) 0.1\"\n *          data-toubiz-range-slider-step=\"(double) 0.4\">\n *\n *      </div>\n *      <div>\n *          <input type=\"number\" min=\"0\" max=\"100\" id=\"target-input-min\" placeholder=\"Bound value of index min\" />\n *          <div id=\"target-display-min_1\"></div>\n *          <div id=\"target-display-min_2\"></div>\n *          <input type=\"number\" min=\"0\" max=\"100\" id=\"target-input-max\" placeholder=\"Bound value of index max\" />\n *          <div id=\"target-display-max\"></div>\n *      </div>\n * </div>\n */\n\nvar ToubizRangeSlider = /*#__PURE__*/function () {\n  /**\n   * @private\n   * @type {ToubizRangeSlider~state}\n   */\n\n  /**\n   * @param {HTMLElement} node\n   */\n  function ToubizRangeSlider(node) {\n    _classCallCheck(this, ToubizRangeSlider);\n\n    _defineProperty(this, \"state\", void 0);\n\n    /** @private {HTMLElement} */\n    this.node = node;\n    /** @private {ToubizRangeSlider~options} */\n\n    this.options = this.extractOptions(node);\n    /** @private {{ min: HTMLInputElement, max: HTMLInputElement }} */\n\n    this.dataField = {\n      min: document.querySelector(this.options.dataField.min),\n      max: document.querySelector(this.options.dataField.max)\n    };\n    this.validateConfiguration();\n    this.options.bounds.min = parseFloat(this.options.bounds.min) || parseFloat(this.dataField.min.min) || 0;\n    this.options.bounds.max = parseFloat(this.options.bounds.max) || parseFloat(this.dataField.max.max) || 0;\n    /** @private {ToubizRangeSlider~state} */\n\n    this.state = {\n      min: parseFloat(this.dataField.min.value) || this.options.bounds.min,\n      max: parseFloat(this.dataField.max.value) || this.options.bounds.max\n    };\n    this.setOptionalSettings();\n    this.setupListeners();\n    this.initializeRangeSlider();\n    this.render();\n  }\n  /**\n   * @param {HTMLElement} node\n   * @returns {ToubizRangeSlider~options}\n   * @private\n   */\n\n\n  _createClass(ToubizRangeSlider, [{\n    key: \"extractOptions\",\n    value: function extractOptions(node) {\n      this.node = node;\n      var options = Object(_nimius_dom_utility__WEBPACK_IMPORTED_MODULE_1__[\"extractPrefixedAttributesFromElement\"])(node, 'data-toubiz-range-slider-');\n      options.input = options.input || {};\n      options.bounds = options.bounds || {}; // Optional settings\n\n      options.dataField = options.dataField || {};\n      options.factor = parseFloat(options.factor) || 1;\n      options.step = parseFloat(options.step) || 1;\n      options.decimals = 0;\n      options.roundFactor = 1;\n      return options;\n    }\n    /**\n     * Updates slider and bound elements to the current state.\n     * Should the slider be on its default values the inputs are cleared.\n     *\n     * @param {boolean} updateSlider - Slider needs to be set to the input values.\n     * @public\n     */\n\n  }, {\n    key: \"render\",\n    value: function render() {\n      var updateSlider = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;\n\n      if (this.state.min !== this.options.bounds.min || this.state.max !== this.options.bounds.max) {\n        var minValue = this.state.min !== null ? this.state.min : this.options.bounds.min;\n        var maxValue = this.state.max !== null ? this.state.max : this.options.bounds.max;\n        this.dataField.min.value = minValue;\n        this.dataField.max.value = maxValue;\n\n        if (this.options.changeEvent) {\n          Object(_nimius_event_utility__WEBPACK_IMPORTED_MODULE_2__[\"fireEvent\"])(this.dataField.min, this.options.changeEvent);\n          Object(_nimius_event_utility__WEBPACK_IMPORTED_MODULE_2__[\"fireEvent\"])(this.dataField.max, this.options.changeEvent);\n        }\n      } else {\n        this.dataField.min.value = '';\n        this.dataField.max.value = '';\n      }\n\n      var _iterator = _createForOfIteratorHelper(this.userField.min),\n          _step;\n\n      try {\n        for (_iterator.s(); !(_step = _iterator.n()).done;) {\n          var field = _step.value;\n          field.value = this.state.min !== this.options.bounds.min ? this.transformValue(this.state.min) : null;\n        }\n      } catch (err) {\n        _iterator.e(err);\n      } finally {\n        _iterator.f();\n      }\n\n      var _iterator2 = _createForOfIteratorHelper(this.userField.max),\n          _step2;\n\n      try {\n        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {\n          var _field = _step2.value;\n          _field.value = this.state.max !== this.options.bounds.max ? this.transformValue(this.state.max) : null;\n        }\n      } catch (err) {\n        _iterator2.e(err);\n      } finally {\n        _iterator2.f();\n      }\n\n      if (this.slider && updateSlider) {\n        this.slider.set([this.state.min, this.state.max]);\n      }\n    }\n    /**\n     * This.options.step is used to determine how many decimals the output should have.\n     *\n     * @private\n     */\n\n  }, {\n    key: \"setOptionalSettings\",\n    value: function setOptionalSettings() {\n      this.userField = {\n        min: this.options.userField.min ? _toConsumableArray(document.querySelectorAll(this.options.userField.min)) : [],\n        max: this.options.userField.max ? _toConsumableArray(document.querySelectorAll(this.options.userField.max)) : []\n      };\n\n      if (this.options.step !== null && !Number.isInteger(this.options.step)) {\n        this.options.decimals = JSON.stringify(this.options.step).split('.')[1].length;\n        this.options.roundFactor = Math.pow(10, this.options.decimals);\n      }\n    }\n    /**\n     * Applies scaling and rounding according to the settings.\n     *\n     * @param {string|number} value\n     * @returns {string}\n     * @private\n     */\n\n  }, {\n    key: \"transformValue\",\n    value: function transformValue(value) {\n      if (this.options.factor) {\n        value *= this.options.factor;\n      }\n\n      value = Math.round(value * this.options.roundFactor) / this.options.roundFactor;\n      return value.toFixed(this.options.decimals);\n    }\n  }, {\n    key: \"updateState\",\n    value: function updateState(_ref) {\n      var min = _ref.min,\n          max = _ref.max;\n      min = parseFloat(min);\n      max = parseFloat(max);\n      var minChanged = !isNaN(min) && this.state.min !== min;\n      var maxChanged = !isNaN(max) && this.state.max !== max;\n      min = Math.max(min, this.options.bounds.min);\n      max = Math.min(max, this.options.bounds.max);\n\n      if (minChanged) {\n        this.state.min = min;\n      }\n\n      if (maxChanged) {\n        this.state.max = max;\n      }\n\n      if (minChanged || maxChanged) {\n        this.render();\n      }\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.slider.reset();\n\n      for (var _i = 0, _arr = [].concat(_toConsumableArray(this.userField.min), _toConsumableArray(this.userField.max)); _i < _arr.length; _i++) {\n        var userField = _arr[_i];\n        userField.value = null;\n      }\n    }\n    /** @private */\n\n  }, {\n    key: \"setupListeners\",\n    value: function setupListeners() {\n      var _this = this;\n\n      var _iterator3 = _createForOfIteratorHelper(this.userField.min),\n          _step3;\n\n      try {\n        var _loop = function _loop() {\n          var field = _step3.value;\n          field.addEventListener('input', function () {\n            return _this.updateState({\n              min: parseFloat(field.value) / _this.options.factor\n            });\n          });\n        };\n\n        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {\n          _loop();\n        }\n      } catch (err) {\n        _iterator3.e(err);\n      } finally {\n        _iterator3.f();\n      }\n\n      var _iterator4 = _createForOfIteratorHelper(this.userField.max),\n          _step4;\n\n      try {\n        var _loop2 = function _loop2() {\n          var field = _step4.value;\n          field.addEventListener('input', function () {\n            return _this.updateState({\n              max: parseFloat(field.value) / _this.options.factor\n            });\n          });\n        };\n\n        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {\n          _loop2();\n        }\n      } catch (err) {\n        _iterator4.e(err);\n      } finally {\n        _iterator4.f();\n      }\n\n      this.node.addEventListener('range-slider.reset', function () {\n        return _this.reset();\n      });\n\n      if (this.dataField.min) {\n        this.dataField.min.addEventListener('change', function () {\n          return _this.updateState({\n            min: _this.dataField.min.value\n          });\n        });\n        this.dataField.min.addEventListener('range-slider.reset', function () {\n          return _this.reset();\n        });\n      }\n\n      if (this.dataField.max) {\n        this.dataField.max.addEventListener('change', function () {\n          return _this.updateState({\n            max: _this.dataField.max.value\n          });\n        });\n        this.dataField.max.addEventListener('range-slider.reset', function () {\n          return _this.reset();\n        });\n      }\n    }\n    /** @private */\n\n  }, {\n    key: \"initializeRangeSlider\",\n    value: function initializeRangeSlider() {\n      var _this2 = this;\n\n      this.slider = nouislider__WEBPACK_IMPORTED_MODULE_0___default.a.create(this.node, {\n        start: [this.state.min, this.state.max],\n        range: {\n          min: [this.options.bounds.min],\n          max: [this.options.bounds.max]\n        },\n        step: this.options.step,\n        keyboardSupport: false,\n        // Handle connections: only middle is connected\n        // See https://refreshless.com/nouislider/slider-options/#section-connect\n        connect: [false, true, false]\n      });\n      this.slider.on('update', function (_ref2) {\n        var _ref3 = _slicedToArray(_ref2, 2),\n            min = _ref3[0],\n            max = _ref3[1];\n\n        var state = {\n          min: parseFloat(min) || _this2.options.bounds.min,\n          max: parseFloat(max) || _this2.options.bounds.max\n        };\n\n        if (state.min !== _this2.state.min || state.max !== _this2.state.max) {\n          _this2.state = state;\n\n          _this2.render(false);\n        }\n      });\n    }\n    /**\n     * Check for validity of the mandatory inputs.\n     *\n     * @private\n     */\n\n  }, {\n    key: \"validateConfiguration\",\n    value: function validateConfiguration() {\n      if (!this.dataField.min || !this.dataField.max) {\n        throw new Error(\"\\n                Error initializing range slider: You must specify at least\\n                [data-toubiz-range-slider-data-field.min] and [data-toubiz-range-slider-data-field.max]\\n                pointing to existing DOM Nodes.\\n            \");\n      } else if (!this.dataField.min.min || !this.dataField.max.max) {\n        console.warn(\"\\n                Warning initializing range slider:\\n                Make sure 'min' and 'max' exist in the bound data fields.\\n                [data-toubiz-range-slider-input]\\n            \");\n      }\n    }\n  }]);\n\n  return ToubizRangeSlider;\n}();\n\n\n\n//# sourceURL=webpack://LIS//Users/Nicki/Sites/toubiz-ort/Packages/Plugins/Newland.AssetsNeos/Scripts/toubiz-range-slider/index.js?");

/***/ })

}]);