<?php
namespace Newland\CityTheme\Form\Finishers;

/*
 * This file is part of the Neos.Form package.
 *
 * (c) Contributors of the Neos Project - www.neos.io
 *
 * This package is Open Source Software. For the full copyright and license
 * information, please view the LICENSE file which was distributed with this
 * source code.
 */

use Neos\Flow\I18n\Service;
use Neos\Flow\ResourceManagement\PersistentResource;
use Neos\Media\Domain\Model\Image;
use Neos\FluidAdaptor\View\StandaloneView;
use Neos\Form\Finishers\EmailFinisher;
use Neos\Form\Core\Model\AbstractFinisher;
use Neos\Form\Exception\FinisherException;
use Neos\SwiftMailer\Message as SwiftMailerMessage;
use Neos\Utility\ObjectAccess;
use Neos\Flow\Annotations as Flow;

/**
 * This finisher extends the core EmailFinisher.
 * With this finisher, also attachments from the multi file upload and the image upload field are
 * attached to the email.
 */
class NewlandEmailFinisher extends EmailFinisher
{
    /**
     * @param SwiftMailerMessage $mail
     * @return void
     * @throws FinisherException
     */
    protected function addAttachments(SwiftMailerMessage $mail)
    {
        $formValues = $this->finisherContext->getFormValues();
        if ($this->parseOption('attachAllPersistentResources')) {
            foreach ($formValues as $formValue) {
                if (is_array($formValue)) {
                    foreach ($formValue as $value) {
                        if ($value instanceof PersistentResource) {
                            $this->addAttachmentToMail($mail, $value);
                        }
                    }
                } elseif ($formValue instanceof PersistentResource) {
                    $this->addAttachmentToMail($mail, $formValue);
                } elseif ($formValue instanceof Image) {
                    $resource = $formValue->getResource();
                    $this->addAttachmentToMail($mail, $resource);
                }
            }
        }
        $attachmentConfigurations = $this->parseOption('attachments');
        if (is_array($attachmentConfigurations)) {
            foreach ($attachmentConfigurations as $attachmentConfiguration) {
                if (isset($attachmentConfiguration['resource'])) {
                    $mail->attach(\Swift_Attachment::fromPath($attachmentConfiguration['resource']));
                    continue;
                }
                if (!isset($attachmentConfiguration['formElement'])) {
                    throw new FinisherException('The "attachments" options need to specify a "resource" path or a "formElement" containing the resource to attach', 1503396636);
                }
                $resource = ObjectAccess::getPropertyPath($formValues, $attachmentConfiguration['formElement']);
                if (!$resource instanceof PersistentResource) {
                    continue;
                }
                $mail->attach(\Swift_Attachment::newInstance(stream_get_contents($resource->getStream()), $resource->getFilename(), $resource->getMediaType()));
            }
        }
    }

    protected function addAttachmentToMail(SwiftMailerMessage $mail, PersistentResource $resource)
    {
        $mail->attach(\Swift_Attachment::newInstance(stream_get_contents($resource->getStream()), $resource->getFilename(), $resource->getMediaType()));
    }
}
