module.exports = {
    'block-no-empty': true,
    'color-no-invalid-hex': true,
    'comment-no-empty': true,
    'declaration-block-no-duplicate-properties': [
        true,
        {
            'ignore': [ 'consecutive-duplicates-with-different-values' ],
        },
    ],
    'declaration-block-no-shorthand-property-overrides': true,
    'font-family-no-duplicate-names': true,
    'font-family-no-missing-generic-family-keyword': true,
    'function-calc-no-unspaced-operator': true,
    'function-linear-gradient-no-nonstandard-direction': true,
    'keyframe-declaration-no-important': true,
    'media-feature-name-no-unknown': true,
    'no-descending-specificity': true,
    'no-duplicate-at-import-rules': true,
    'no-duplicate-selectors': true,
    'no-empty-source': true,
    'no-extra-semicolons': true,
    'no-invalid-double-slash-comments': true,
    'property-no-unknown': true,
    'selector-pseudo-class-no-unknown': true,
    'selector-pseudo-element-no-unknown': true,
    'selector-type-no-unknown': true,
    'string-no-newline': true,
    'unit-no-unknown': true,

    'plugins': [
        'stylelint-scss',
    ],

    'ignoreFiles': [
        './Sass/tools/_mappy-breakpoints.scss',
        './Sass/vendor/**/*.scss',
        './Packages/Sites/Newland.CityTheme/Resources/Public/Stylesheets/**/*.css',
    ],

    'rules': {
        'indentation': 4,
        'max-empty-lines': 2,
        'string-quotes': 'single',
        'shorthand-property-no-redundant-values': true,
        'value-no-vendor-prefix': true,
        'property-no-vendor-prefix': true,
        'declaration-no-important': true,
        'declaration-block-no-duplicate-properties': true,
        // eslint-disable-next-line max-len
        'selector-class-pattern': '^([\\.\\%]?[a-z]*[-]?[a-z0-9\\-]*)(\\.[a-z0-9\\-]*)?(__[a-z0-9]*[-]?[a-z0-9\\-]*)?(--[a-z0-9]*[-]?[a-z0-9\\-]*)?(\\:[a-z]*)*$',
        'selector-max-class': 3,
        'selector-max-compound-selectors': 3,
        'selector-max-type': 2,
        'selector-max-id': 0,
        'selector-no-vendor-prefix': true,
        'at-rule-no-vendor-prefix': true,
        'max-nesting-depth': 3,
        'color-hex-case': 'lower',
        'font-family-name-quotes': 'always-unless-keyword',
        'function-comma-space-after': 'always',
        'function-name-case': 'lower',
        'function-url-quotes': 'always',
        'number-leading-zero': 'never',
        'number-no-trailing-zeros': true,
        'length-zero-no-unit': true,
        'unit-case': 'lower',
        'value-keyword-case': 'lower',
        'value-list-comma-newline-after': 'never-multi-line',
        'value-list-comma-newline-before': 'never-multi-line',
        'value-list-comma-space-after': 'always',
        'value-list-comma-space-before': 'never',
        'property-case': 'lower',
        'declaration-bang-space-after': 'never',
        'declaration-bang-space-before': 'always',
        'declaration-colon-space-after': 'always',
        'declaration-colon-space-before': 'never',
        'declaration-empty-line-before': 'never',
        'declaration-block-semicolon-newline-after': 'always-multi-line',
        'declaration-block-semicolon-newline-before': 'never-multi-line',
        'declaration-block-semicolon-space-after': 'always-single-line',
        'declaration-block-semicolon-space-before': 'never',
        'declaration-block-trailing-semicolon': 'always',
        'block-closing-brace-empty-line-before': 'never',
        'block-closing-brace-newline-after': 'always',
        'block-closing-brace-newline-before': 'always-multi-line',
        'block-closing-brace-space-before': 'always-single-line',
        'block-opening-brace-newline-after': 'always-multi-line',
        'block-opening-brace-space-after': 'always-single-line',
        'selector-attribute-brackets-space-inside': 'never',
        'selector-attribute-operator-space-after': 'never',
        'selector-attribute-operator-space-before': 'never',
        'selector-attribute-quotes': 'never',
        'selector-combinator-space-after': 'always',
        'selector-combinator-space-before': 'always',
        'selector-descendant-combinator-no-non-space': true,
        'selector-pseudo-class-case': 'lower',
        'selector-pseudo-class-parentheses-space-inside': 'never',
        'selector-pseudo-element-case': 'lower',
        'selector-pseudo-element-colon-notation': 'double',
        'selector-type-case': 'lower',
        'selector-list-comma-newline-after': 'always',
        'rule-empty-line-before': [
            'always-multi-line',
            {
                'except': [ 'first-nested' ],
                'ignore': [ 'after-comment' ],
            },
        ],
        'media-feature-colon-space-after': 'always',
        'media-feature-colon-space-before': 'never',
        'media-feature-parentheses-space-inside': 'never',
        'media-feature-range-operator-space-after': 'always',
        'media-feature-range-operator-space-before': 'always',
        'media-feature-name-case': 'lower',
        'at-rule-empty-line-before': [
            'always',
            {
                'ignore': [ 'after-comment' ],
                'except': [
                    'blockless-after-same-name-blockless',
                    'first-nested',
                ],
                'ignoreAtRules': [
                    'apply',
                ],
            },
        ],
        'at-rule-name-case': 'lower',
        'at-rule-name-space-after': 'always-single-line',
        'at-rule-semicolon-space-before': 'never',

        'scss/at-rule-no-unknown': [
            true,
            {
                'ignoreAtRules': [
                    'tailwind',
                    'apply',
                    'variants',
                    'responsive',
                    'screen',
                    'function',
                    'return',
                ],
            },
        ],

        'scss/at-import-no-partial-leading-underscore': true,

        'comment-whitespace-inside': 'always',
        'no-eol-whitespace': true,
        'no-missing-end-of-source-newline': true,
    },
};
