import { deleteCookie } from './common';

export const disableMatomo = () => {
    // eslint-disable-next-line no-underscore-dangle
    const tracker = window._paq || [];
    tracker.push([ 'forgetConsentGiven' ]);
    tracker.push([ 'optUserOut' ]);

    deleteCookie('paddlejs_campaign_referrer');
    deleteCookie('paddlejs_checkout_variant');
    deleteCookie('MATOMO_SESSID');
};

export const enableMatomo = () => {
    // eslint-disable-next-line no-underscore-dangle
    const tracker = window._paq || [];
    tracker.push([ 'rememberConsentGiven' ]);
    tracker.push([ 'forgetUserOptOut' ]);
};

export const initMatomo = () => {
    // in opt-in mode, wait for event to allow injection
    document.addEventListener('cookie-consent-status-change', event => {
        if (event.detail.status === 'allow') {
            enableMatomo();
        } else {
            disableMatomo();
        }
    });
};
