const gulp = require('gulp');
const stylelint = require('gulp-stylelint');
const merge = require('lodash/merge');

/*
 *  Default configuration for this task. Adjustments specific
 *  to the site package should be specified as overrrides in its
 *  gulpfile.
 */
const defaultConfig = {
    // Path glob for all sass files in this site package.
    src: './Sass/**/*.scss',

    /*
     *  Options to be passed to gulp-stylelint. See
     *  Check https://www.npmjs.com/package/gulp-stylelint for
     *  available settings.
     */
    lintOptions: {
        failAfterError: false,
        reporters: [
            { formatter: 'string', console: true },
        ],
    },
};

module.exports = config => {
    const mergedConfig = config ? merge(defaultConfig, config) : defaultConfig;

    return gulp
        .src(mergedConfig.src)
        .pipe(stylelint(mergedConfig.lintOptions));
};
