import { onPageLoadComplete } from '@nimius/event-utility';

const initWebcamsNoCache = () => {
    const webcamElements = document.querySelectorAll('[data-webcam-nocache]');

    if (webcamElements) {
        for (const webcamElement of webcamElements) {
            // appends timestamp to data-src for cache busting
            const src = webcamElement.getAttribute('data-src');

            if (src != '') {
                const newSrc = src + '?ver=' + Date.now();
                webcamElement.setAttribute('data-src', newSrc);
            }
        }
    }
};

onPageLoadComplete(() => {
    initWebcamsNoCache();
});
