<?php
namespace Newland\CityTheme\ViewHelpers\Format;

/*
 * This file is part of the "neos-viewhelpers" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * PhoneNumber format view helper.
 *
 * Renders input as valid phone number for the URL scheme
 */
class PhoneNumberViewHelper extends AbstractViewHelper
{

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('value', 'string', 'The value to remove spaces from');
    }

    public function render(): string
    {
        $value = array_key_exists('value', $this->arguments) ?
            $this->arguments['value'] :
            null;

        if (!$value) {
            $value = $this->renderChildren();
        }

        return preg_replace(
            '/[^\d\+]/',
            '',
            $value
        );
    }
}
