import { onPageLoadComplete } from '@nimius/event-utility';

// Set Europe/Berlin time options to be used in the current date, to prevent miscalculations due to different timezones
const berlinTimeOptions = {
    timeZone: 'Europe/Berlin',
    hour12: false,
};

const body = document.body;

const initCountdown = () => {
    // Get all countdown elements and set current date, which is converted to ms
    const countdowns = document.querySelectorAll('[data-countdown]');

    if (countdowns != null) {
        body.classList.add('has-countdown');

        countdowns.forEach(countdown => {
            // Collect all necessary tags and informations
            const endTextItem = countdown.querySelector('[data-countdown-end-text]');
            const endDate = new Date(countdown.getAttribute('data-countdown-end-date')).getTime();
            const countdownItems = countdown.querySelectorAll('[data-countdown-item]');
            const dayItem = countdown.querySelector('[data-countdown-days]');
            const hourItem = countdown.querySelector('[data-countdown-hours]');
            const minuteItem = countdown.querySelector('[data-countdown-minutes]');
            const secondItem = countdown.querySelector('[data-countdown-seconds]');

            const initCountdownInterval = setInterval(() => {
                const currentDate = new Date().toLocaleString('en-US', berlinTimeOptions);
                const currentDateMs = new Date(currentDate).getTime();

                const timespan = endDate - currentDateMs;

                const days = Math.floor(timespan / (1000 * 60 * 60 * 24));
                const hours = Math.floor((timespan % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((timespan % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((timespan % (1000 * 60)) / 1000);

                dayItem.innerHTML = days < 10 ? '0' + days : days;
                hourItem.innerHTML = hours < 10 ? '0' + hours : hours;
                minuteItem.innerHTML = minutes < 10 ? '0' + minutes : minutes;
                secondItem.innerHTML = seconds < 10 ? '0' + seconds : seconds;

                if (timespan < 0) {
                    // If no "end text" is set, set all values to 00 to prevent negative values
                    if (endTextItem == null) {
                        dayItem.innerHTML = '00';
                        hourItem.innerHTML = '00';
                        minuteItem.innerHTML = '00';
                        secondItem.innerHTML = '00';
                    // If end text is set, remove all tags and items and only set "end text" value to show up in the countdown element
                    } else {
                        countdownItems.forEach(item => {
                            item.classList.add('hidden');
                        });

                        endTextItem.classList.remove('hidden');
                    }

                    clearInterval(initCountdownInterval);
                }
            }, 1000);
        });
    }
};

onPageLoadComplete(() => {
    initCountdown();
});