const gulp = require('gulp');
const merge = require('lodash/merge');

/*
 *  Default configuration for this task. Actual configuration
 *  is placed in gulpfile.js.
 */
const defaultConfig = [
    {
        /*
         *  Option watchMap is an Array of Objects with properties
         *  paths (string, path glob) and tasks (array of strings,
         *  names of the tasks to execute). Tasks will be executed
         *  in parallel.
         */
        watchMap: [],
    },
];

module.exports = (done, config) => {
    const mergedConfig = config ? merge(defaultConfig, config) : defaultConfig;
    mergedConfig.watchMap.forEach(({ paths, tasks }) => gulp.watch(paths, gulp.parallel(...tasks)));
    done();
};
