const gutil = require('gulp-util');
const webpack = require('webpack');
const webpackConfig = require('../webpack.config');

module.exports = done => {
    webpack(webpackConfig, (err, stats) => {
        if (err) {
            gutil.log(gutil.colors.red(err()));
        }
        const result = stats.toJson();
        if (result.errors.length) {
            result.errors.forEach((error) => {
                gutil.log(gutil.colors.red(error));
            });
        }
        done();
    });
};
