/*
 *  Importing core-js/stable and regenerator-runtime
 *  to replace @babel/polyfill (deprecated).
 *
 *  See https://github.com/zloirock/core-js#babelpolyfill
 *  or https://github.com/zloirock/core-js/blob/master/docs/2019-03-19-core-js-3-babel-and-a-look-into-the-future.md
 */
import 'core-js/stable';
import 'regenerator-runtime/runtime';

// We made it here because js is enabled, so remove no-js class.
document.body.classList.remove('no-js');

// Vendor imports (external scripts)
import 'lazysizes';

/*
 *  Main/Dynamic script imports.
 *  It is recommended to use dynamic imports for loading chunks
 *  lazily like done in toubiz-styleguide.
 *
 *  Place the script which checks for the node in /main and
 *  the actual script you want to import in /dynamic. Import the
 *  main script here.
 *
 *  Example:
 *  /dynamic/dynamic-import-target.js.example
 *  /main/dynamic-import-check.js.example
 */
import './main/site-tracking';
import './main/video';
import './main/search-focus';
import './main/reduce';
import './main/reveal';
import './main/flatpickr-init';
import './main/amount-selection';
import './main/site-header';
import './main/hide-body-overflow';
import './main/trigger-bind';
import './main/webcams-nocache';
import './main/scroll-to-top';
import './main/notification';

/*
 *  Toubiz components import.
 *  Will only load the chunks (e.g. toubiz-map) which are
 *  needed. If a chunk is needed is determined by checking
 *  the DOM for existing nodes (with e.g. data-toubiz-map).
 */
import '@newland/assets-neos';
