import { initGoogleAnalytics } from './analytics';
import { initGoogleTagManager } from './tag-manager';
import { initMatomo } from './matomo';

export const initSiteTracking = settings => {
    if (settings.type === 'analytics') {
        initGoogleAnalytics(settings);
    } else if (settings.type === 'tag-manager') {
        initGoogleTagManager(settings);
    } else if (settings.type === 'matomo') {
        initMatomo();
    }
};
