/* eslint-disable max-lines */
const { toubizComponentLibrary } = require('@newland/toubiz-widget/tailwind');

const colorNames = [ 'primary', 'secondary', 'gray', 'positive', 'neutral', 'negative', 'cta', 'link', 'focus', 'accent', 'warning', 'ambient' ];
const shades = [ '100', '200', '300', '400', '500', '600', '700', '800', '900' ];
const colors = {};

for (const colorName of colorNames) {
    colors[colorName] = {};
    for (const shade of shades) {
        colors[colorName][shade] = `var(--color-${colorName}-${shade})`;
    }
}

module.exports = toubizComponentLibrary({
    toubizComponentLibrary: {
        generateLegacySingularColors: true,
    },
    purge: {
        enabled: false,
    },
    theme: {
        screens: {
            'xs': '30em',
            'sm': '40em',
            'md': '48em',
            'lg': '62em',
            'xl': '75em'
        },

        extend: {
            colors,
            fontWeight: {
                'weight-heading': 'var(--tb-font-weight-heading)',
                'weight-body': 'var(--tb-font-weight-body)',
            },
            fontFamily: {
                heading: 'var(--tb-font-heading)',
                body: 'var(--tb-font-body)',
            },
        }
    },
});
