/**
 * Interface that should be implemented by every map implementation if it can display tours.
 *
 * @interface MapWithTour
 */

/**
 * Draws the tour of the given marker onto the map.
 * Note, that the marker could also not be a tour and thus not have points to be drawn.
 *
 * @function
 * @name MapWithTour#drawTourOntoMap
 * @param {Marker} marker
 * @param {boolean} fitBoundsToTour
 * @returns {Promise|void}
 */

/**
 * Hides all currently drawn tours from the map.
 *
 * @function
 * @name MapWithTour#clearTours
 * @returns {Promise|void}
 */
