import ToubizRangeSlider from './index';
import { fireEvent } from '@nimius/event-utility';
import { expect } from 'chai';

describe('ToubizRangeSlider', () => {
    let dom;
    let slider;

    beforeEach(() => {
        dom = document.createElement('div');
        dom.innerHTML = `
            <div>
                <div data-toubiz-range-slider
                     data-toubiz-range-slider-outputs.min="#target-output-min__1, #target-output-min__2"
                     data-toubiz-range-slider-outputs.max="#target-output-max__1"
                     data-toubiz-range-slider-input.min="#target-input-min"
                     data-toubiz-range-slider-input.max="#target-input-max"
                     data-toubiz-range-slider-factor="0.1"
                     data-toubiz-range-slider-step="0.1"
        
                >
        
                </div>
            </div>
        
            <div>
                <input type="number" min="0" max="100" id="target-input-min" placeholder="Bound value of index min" />
                <input type="number" min="0" max="100" id="target-input-max" placeholder="Bound value of index max" />
                <div id="target-output-min__1"></div>
                <div id="target-output-min__2"></div>
                <div id="target-output-max__1"></div>
            </div>
        `;

        document.body.appendChild(dom);

        slider = new ToubizRangeSlider(
            dom.querySelector('[data-toubiz-range-slider]')
        );
    });

    afterEach(() => {
        slider = null;
        document.body.removeChild(dom);
    });

    it('should set bound elements', () => {
        expect(dom.querySelector('#target-input-min').value).to.equal('');
        expect(dom.querySelector('#target-input-max').value).to.equal('');
        expect(dom.querySelector('#target-output-min__1').innerText).to.equal('0.0');
        expect(dom.querySelector('#target-output-min__2').innerText).to.equal('0.0');
        expect(dom.querySelector('#target-output-max__1').innerText).to.equal('10.0');
    });

    it('should update values if handles change', () => {
        slider.slider.set([ 20, 40 ]);
        expect(dom.querySelector('#target-input-min').value).to.equal('20');
        expect(dom.querySelector('#target-input-max').value).to.equal('40');
        expect(dom.querySelector('#target-output-min__1').innerText).to.equal('2.0');
        expect(dom.querySelector('#target-output-min__2').innerText).to.equal('2.0');
        expect(dom.querySelector('#target-output-max__1').innerText).to.equal('4.0');
    });

    it('should round according to step', () => {
        slider.slider.set([ 31.41, 62.89 ]);
        expect(dom.querySelector('#target-input-min').value).to.equal('31.4');
        expect(dom.querySelector('#target-input-max').value).to.equal('62.9');
        expect(dom.querySelector('#target-output-min__1').innerText).to.equal('3.1');
        expect(dom.querySelector('#target-output-min__2').innerText).to.equal('3.1');
        expect(dom.querySelector('#target-output-max__1').innerText).to.equal('6.3');
    });

    it('should update handles if input changes', () => {
        dom.querySelector('#target-input-min').value = 10;
        fireEvent(dom.querySelector('#target-input-min'), 'input');
        dom.querySelector('#target-input-max').value = 90;
        fireEvent(dom.querySelector('#target-input-max'), 'input');
        expect(dom.querySelector('#target-input-min').value).to.equal('10');
        expect(dom.querySelector('#target-input-max').value).to.equal('90');
        expect(dom.querySelector('#target-output-min__1').innerText).to.equal('1.0');
        expect(dom.querySelector('#target-output-min__2').innerText).to.equal('1.0');
        expect(dom.querySelector('#target-output-max__1').innerText).to.equal('9.0');
    });

    it('should stay in boundaries', () => {
        slider.slider.set([ -999, 999 ]);
        expect(dom.querySelector('#target-input-min').value).to.equal('');
        expect(dom.querySelector('#target-input-max').value).to.equal('');
        expect(dom.querySelector('#target-output-min__1').innerText).to.equal('0.0');
        expect(dom.querySelector('#target-output-min__2').innerText).to.equal('0.0');
        expect(dom.querySelector('#target-output-max__1').innerText).to.equal('10.0');
    });

});
