import { onPageLoadComplete } from '@nimius/event-utility';
import { extractPrefixedAttributesFromElement } from '@nimius/dom-utility';

onPageLoadComplete(async () => {
    const nodes = document.querySelectorAll('[data-toubiz-map]');
    if (nodes.length > 0) {
        const [ Vue, MapModule ] = await Promise.all([
            import('vue').then(mod => mod.default),
            import('../../Scripts/toubiz-map/toubiz-map.vue'),
        ]);
        const TbMap = MapModule.default;

        for (const node of nodes) {
            const settings = extractPrefixedAttributesFromElement(node, 'data-toubiz-map.');
            new Vue({
                el: node,
                render(createElement) {
                    return createElement(
                        TbMap,
                        { props: { settings:  MapModule.prepareSettings(settings) } }
                    );
                }
            })
        }
    }
});
