function GeolocationMarker(position, map) {
    this.position = new google.maps.LatLng(position.lat, position.lng);
    this.setMap(map);
}

GeolocationMarker.prototype = new google.maps.OverlayView();

GeolocationMarker.prototype.draw = function() {
    if (!this.div) {
        this.div = document.createElement('div');
        this.div.className = 'tb-map-geolocation-marker tb-map-geolocation-marker--google';
        this.div.style.position = 'absolute';
        this.div.innerHTML = `
            <span class="tb-map-geolocation-marker__backdrop"></span>
            <span class="tb-map-geolocation-marker__icon"></span>
        `;
        const panes = this.getPanes();
        panes.overlayImage.appendChild(this.div);
    }

    const point = this.getProjection().fromLatLngToDivPixel(this.position);

    if (point) {
        this.div.style.left = `${point.x}px`;
        this.div.style.top = `${point.y}px`;
    }
};
