import { AjaxFormReload } from './ajax-form-reload';
import { expect } from 'chai';

describe('AjaxFormReload', () => {
    let ajaxFormReload;
    let dom;
    let actual;
    let expected;

    beforeEach(() => {
        dom = document.createElement('form');
        ajaxFormReload = new AjaxFormReload(
            dom,
            {
                target: 'testTarget',
                action: 'testAction',
                method: 'GET',
                updateUrl: true,
                updateUrlParameters: 'query',
                updateUrlPluginNamespace: '--vendor_package_name-pluginname',
            },
        );
    });

    it('should replace part of the array', () => {
        const currentParameters = {
            q: '/index.php/de/dmynode',
            '--vendor_package_name-pluginname': {
                query: {
                    page: 1,
                    categories: {
                        'bca1e299-ee6b-487a-9e37-8e8359f69ac9': 'bca1e299-ee6b-487a-9e37-8e8359f69ac9',
                    },
                },
            },
        };
        const requestParameters = {
            query: {
                page: 1,
                categories: {
                    'cde5be0e-93a5-42a7-9686-2ef99b45ecff': 'cde5be0e-93a5-42a7-9686-2ef99b45ecff',
                },
            },
        };
        actual = ajaxFormReload.replaceParametersInArray(currentParameters, requestParameters);
        expected = {
            q: '/index.php/de/dmynode',
            '--vendor_package_name-pluginname': {
                query: {
                    page: 1,
                    categories: {
                        'cde5be0e-93a5-42a7-9686-2ef99b45ecff': 'cde5be0e-93a5-42a7-9686-2ef99b45ecff',
                    },
                },
            },
        };
        expect(expected).to.eql(actual);
    });

    it('should add query parameters to empty array', () => {
        const currentParameters = {};
        const requestParameters = {
            query: {
                page: 1,
                categories: {
                    'bca1e299-ee6b-487a-9e37-8e8359f69ac9': 'bca1e299-ee6b-487a-9e37-8e8359f69ac9',
                },
            },
        };
        actual = ajaxFormReload.replaceParametersInArray(currentParameters, requestParameters);
        expected = {
            '--vendor_package_name-pluginname': {
                query: {
                    page: 1,
                    categories: {
                        'bca1e299-ee6b-487a-9e37-8e8359f69ac9': 'bca1e299-ee6b-487a-9e37-8e8359f69ac9',
                    },
                },
            },
        };
        expect(expected).to.eql(actual);
    });

    it('should replace part of the query string', () => {
        // eslint-disable-next-line max-len
        const currentPath = 'q=%2Findex.php%2Fde%2Fmynode&--vendor_package_name-pluginname%5Bquery%5D%5Bpage%5D=1&--vendor_package_name-pluginname%5Bquery%5D%5Bcategories%5D%5Bbca1e299-ee6b-487a-9e37-8e8359f69ac9%5D=bca1e299-ee6b-487a-9e37-8e8359f69ac9';
        // eslint-disable-next-line max-len
        const requestPath = 'query%5Bpage%5D=1&query%5Bcategories%5D%5Bcde5be0e-93a5-42a7-9686-2ef99b45ecff%5D=cde5be0e-93a5-42a7-9686-2ef99b45ecff';
        actual = ajaxFormReload.replaceParametersInPath(currentPath, requestPath);
        // eslint-disable-next-line max-len
        expected = 'q=%2Findex.php%2Fde%2Fmynode&--vendor_package_name-pluginname%5Bquery%5D%5Bpage%5D=1&--vendor_package_name-pluginname%5Bquery%5D%5Bcategories%5D%5Bcde5be0e-93a5-42a7-9686-2ef99b45ecff%5D=cde5be0e-93a5-42a7-9686-2ef99b45ecff';
        expect(expected).to.equal(actual);
    });
});
