import { fireEvent } from '@nimius/event-utility';

/**
 *
 * This opens the first list item of the tab navigation
 * or hides the navigation if no items are available
 *
 */
export class ToubizTabNavigation {

    /**
     * @param {HTMLElement} element
     */
    constructor (element) {
        /** @private {HTMLElement} */
        this.element = element;

        /** @private {NodeList} */
        this.firstListItem = this.element.querySelector('li');

        if (this.firstListItem) {
            fireEvent(this.firstListItem, 'target-enhancement.open');
            this.firstListItem.setAttribute('aria-expanded', 'true');
        } else {
            element.style.display = 'none';
        }
    }
}
