export const hasLanguageLabels = {
    props: {
        languageLabels: {
            type: Object,
            default: () => ({}),
        },
    },
    methods: {
        translate (label, replacements = []) {
            if (!this.languageLabels[label]) {
                return `${label}[${replacements.map(r => r.toString()).join(',')}]`;
            }

            let text = this.languageLabels[label];
            for (const key of Object.keys(replacements)) {
                text = text.replace(new RegExp(`\\{${key}\\}`, 'g'), replacements[key]);
            }
            return text;
        },
    },
};
