export class GeolocationMarker {
    constructor(L, position, map) {
        this.L = L;
        this.position = position;
        this.map = map;
        this.draw();
    }

    draw() {
        const customIcon = this.L.divIcon({
            iconSize: this.L.Point(20, 20),
            className: 'tb-map-geolocation-marker-wrapper',
            html: `
                <div class="tb-map-geolocation-marker tb-map-geolocation-marker--leaflet">
                    <span class="tb-map-geolocation-marker__backdrop"></span>
                    <span class="tb-map-geolocation-marker__icon"></span>
                </div>
            `,
        });

        this.L.marker(this.position, {
            icon: customIcon,
            keyboard: false,
            title: 'Current position',
            bubblingMouseEvents: true,
        }).addTo(this.map);
    }
}
