import { ApiImporter } from './api-importer';

/**
 * The following settings are available:
 * - `categories`: Array of categories to add.
 * - `markers`: Array of markers to add.
 * - `template`: Selector of the template that should be used for the marker content.
 *               If not set then the marker content will be disabled.
 *               Marker templates use doT: https://github.com/olado/doT
 */
export class JsonImporter extends ApiImporter {

    import() {
        if (this.settings.markers) {
            const data = Object.values(JSON.parse(this.settings.markers));
            const markers = data.map(d => this.dataToMarker(d));
            this.source.addMarkers(markers);
        }

        if (this.settings.filterItems) {
            const data = Object.values(JSON.parse(this.settings.filterItems));
            const items = data.map(d => this.dataToFilterItem(d));
            this.source.addFilterItems(items);
        }

        return Promise.resolve();
    }

}
