/**
 * Integration base class. Every concrete implementation must extend this base
 * class and overwrite the static `test` method.
 *
 * The `intialize` method should also be overidden to initialize the integration.
 */
export class Integration {

    /**
     * @param {HTMLElement} node
     */
    constructor(node) {
        /** @private {HTMLElement} */
        this.node = node;

        this.initialize();
    }

    /**
     * @param {HTMLElement} node
     * @returns {boolean}
     */
    // eslint-disable-next-line no-unused-vars
    static test(node) {
        throw new Error('Not implemented');
    }

    /** @protected */
    initialize() {}

}
