import { expect } from 'chai';
import { attributeSelector, encodeForCssSelector } from './selector-utilities';

describe('encodeForCssSelector', () => {
    it('should not change regular strings', () => {
        expect(encodeForCssSelector('foo')).to.equal('foo');
        expect(encodeForCssSelector('bar')).to.equal('bar');
        expect(encodeForCssSelector('baz2')).to.equal('baz2');
    });
    it('should escape characters no allowed in CSS Selectors', () => {
        expect(encodeForCssSelector('foo.dot')).to.equal('foo\\.dot');
        expect(encodeForCssSelector('foo@at')).to.equal('foo\\@at');
        expect(encodeForCssSelector('foo:colon')).to.equal('foo\\:colon');
    });
    it('should not change characters allowed in CSS selectors', () => {
        expect(encodeForCssSelector('foo-dash')).to.equal('foo-dash');
        expect(encodeForCssSelector('foo_underscore')).to.equal('foo_underscore');
    });
});

describe('attributeSelector', () => {
    it('should transform an attribute name into a selector', () => {
        expect(attributeSelector('data-foo')).to.equal('[data-foo]');
    });
    it('should include the value in the selector if given', () => {
        expect(attributeSelector('data-foo', 'value')).to.equal('[data-foo="value"]');
    });
    it('should escape values', () => {
        expect(attributeSelector('data.foo', 'value')).to.equal('[data\\.foo="value"]');
    });
    it('should build valid selectors', () => {
        const target = document.createElement('div');
        target.setAttribute('data-foo.bar', 'test');
        const element = document.createElement('div');
        element.appendChild(target);

        expect(
            element.querySelector(attributeSelector('data-foo.bar', 'test'))
        ).to.equal(target);
    });
});
