import { onPageLoadComplete } from '@nimius/event-utility';
import { loadOutdoorActiveForTracking, loadOutdoorActiveFull } from '../../Scripts/toubiz-poi/outdoor-active-api';
import { extractPrefixedAttributesFromElement } from '@nimius/dom-utility';

/**
 * @param {HTMLElement} element
 * @param {string} tourId
 */
function initializeOutdoorActiveMap(element, tourId) {
    loadOutdoorActiveFull().then(oa => oa.api.maps((oamaps, gm) => {
        const { GeomLayer, map: initializeMap } = oamaps;
        const layer = new GeomLayer(tourId, { fitPoiBounds : true, defaultIW : true });

        layer.whenLoaded(() => {
            const mapTypeIds = [ 'oa_map', 'oa_hybrid', 'oa_map_winter' ];
            if (gm.MapTypeId) {
                mapTypeIds.push(gm.MapTypeId.TERRAIN);
                mapTypeIds.push(gm.MapTypeId.SATELLITE);
            }

            const zc = layer.getZoomCenter(element);
            const mapConfig = {
                center : zc.center,
                zoom : zc.zoom,
                bounds: layer.getBounds(),
                mapTypeId : mapTypeIds[ 0 ],
                mapTypeControlOptions : { mapTypeIds },
                oa : { earth : true },
            };

            const map = initializeMap(element, mapConfig);
            layer.setMap(map);
        });
    }));
}

onPageLoadComplete(async () => {
    const resultsNode = document.querySelector('[data-toubiz-results="poi"]');
    if (resultsNode) {
        // eslint-disable-next-line max-len
        const { default: ToubizPoiResultsListController } = await import(/* webpackChunkName: "toubiz-poi-results-list-controller" */ '../../Scripts/toubiz-poi/results-list-controller');
        new ToubizPoiResultsListController(resultsNode);
    }
});

onPageLoadComplete(async () => {
    if (document.querySelector('[data-toubiz-opening-times]')) {
        // eslint-disable-next-line max-len
        const { default: parseOpeningTimes } = await import(/* webpackChunkName: "parse-opening-times" */ '../../Scripts/toubiz-poi/parse-opening-times');

        for (const node of document.querySelectorAll('[data-toubiz-opening-times]')) {
            parseOpeningTimes(node);
        }
    }
});

onPageLoadComplete(() => {
    if (document.querySelector('[data-oa-map]')) {
        for (const tour of document.querySelectorAll('[data-oa-tour-id]')) {
            initializeOutdoorActiveMap(tour, tour.dataset.oaTourId);
        }
    }

    if (document.querySelector('[data-oa-tracking]')) {
        for (const teaser of document.querySelectorAll('[data-oa-tracking-type="teaser"]')) {
            if (teaser.dataset.oaTrackingId) {
                loadOutdoorActiveForTracking().then(ax => ax.api.trackTeaser(teaser.dataset.oaTrackingId));
            }
        }

        for (const tour of document.querySelectorAll('[data-oa-tracking-type="detail"]')) {
            if (tour.dataset.oaTrackindId) {
                loadOutdoorActiveForTracking().then(ax => ax.api.trackDetail(tour.dataset.oaTrackindId));
            }
        }
    }
});

onPageLoadComplete(async () => {
    const elements = document.querySelectorAll('[data-toubiz-standalone-map]');
    if (elements.length > 0) {
        // eslint-disable-next-line max-len
        const { StandaloneMap } = await import(/* webpackChunkName: "static-map" */ '../../Scripts/toubiz-map/standalone-map');
        for (const element of elements) {
            new StandaloneMap(element, extractPrefixedAttributesFromElement(element, 'data-toubiz-standalone-map.'));
        }
    }
});


onPageLoadComplete(async () => {
    const elements = document.querySelectorAll('[data-outdooractive-pdf-download]');
    if (elements.length > 0) {
        // eslint-disable-next-line max-len
        const { OutdoorActivePdfDownload } = await import(/* webpackChunkName: "outdoor-active-pdf-download" */ '../../Scripts/toubiz-poi/outdoor-active-pdf-download');
        for (const button of document.querySelectorAll('[data-outdooractive-pdf-download]')) {
            new OutdoorActivePdfDownload(button, button.getAttribute('data-outdooractive-pdf-download'));
        }
    }
});

