import { onPageLoadComplete } from '@nimius/event-utility';

onPageLoadComplete(async () => {
    if (document.querySelector('[data-toubiz-expandable-text]')) {
        // eslint-disable-next-line max-len
        const { default: ToubizExpandableText } = await import(/* webpackChunkName: "toubiz-expandable-text" */ '../../Scripts/toubiz-expandable-text');

        for (const node of document.querySelectorAll('[data-toubiz-expandable-text]')) {
            new ToubizExpandableText(node);
        }
    }
});
