import { onPageLoadComplete } from '@nimius/event-utility';
import { extractPrefixedAttributesFromElement } from '@nimius/dom-utility';

onPageLoadComplete(async () => {
    const nodes = document.querySelectorAll('[data-toubiz-search]');

    if (nodes.length > 0) {
        const [ Vue, SearchModule ] = await Promise.all([
            import(/* webpackChunkName: "vue" */ 'vue').then(mod => mod.default),
            import(/* webpackChunkName: "vue" */ '../../Scripts/toubiz-search/toubiz-search.vue'),
        ]);
        const TbSearch = SearchModule.default;

        for (const node of nodes) {
            const settings = extractPrefixedAttributesFromElement(node, 'data-toubiz-search.');
            new Vue({
                el: node,
                render(createElement) {
                    return createElement(
                        TbSearch,
                        { props: { settings } }
                    );
                }
            })
        }
    }
});
