export default class ToubizBrochure {

    /**
     * @param {HTMLElement} node
     */
    constructor(node) {
        /** @private {HTMLElement} */
        this.node = node;

        /** @private {HTMLButtonElement} */
        this.button = document.querySelector('[data-toubiz-brochure-button]');

        this.init();
    }

    init() {
        this.node.addEventListener('click', () => this.onClick(), true);
    }
    onClick() {
        if (this.button) {
            if (document.querySelector('[data-toubiz-brochure-checkbox]:checked')) {
                this.button.classList.add('is-active');
            } else {
                this.button.classList.remove('is-active');
            }
        }
    }

}
