/** @abstract */
export class Importer {

    /**
     * @param {FilteredMarkerSource} source
     * @param {object} settings
     */
    constructor(source, settings) {
        /** @protected {FilteredMarkerSource} */
        this.source = source;

        /** @protected {object} */
        this.settings = this.prepareSettings(settings);
    }

    prepareSettings(settings) {
        return settings;
    }

    /**
     * @param {object} settings
     * @returns {Promise}
     */
    // eslint-disable-next-line no-unused-vars
    import(settings) {
        throw new Error('`import` must be implemented in concrete importers.');
    }

}
