import { dateToShortIsoString } from './date-formatting';
import { expect } from 'chai';

describe('date-formatting', () => {
    const dates = [
        [ new Date('2018-12-12'), '2018-12-12' ],
        [
            (() => {
                const a = new Date();
                a.setYear(1994);
                a.setMonth(9);
                a.setDate(13);
                return a;
            })(),
            '1994-10-13',
        ],
        [
            (() => {
                const a = new Date();
                a.setTime(1542710132000);
                return a;
            })(),
            '2018-11-20',
        ],
    ];

    it('should correctly format dates as YYYY-MM-DD', () => {
        for (const [ date, expected ] of dates) {
            const formatted = dateToShortIsoString(date);
            expect(formatted).to.match(/\d{4}-[01]\d-[123]\d/);
            expect(formatted).to.equal(expected);
        }
    });
});
