/**
 * Formats a Date object as a short ISO String (YYYY-MM-DD).
 *
 * @param {Date} date
 * @returns {string}
 */
export function dateToShortIsoString(date) {
    return date.toISOString().substr(0, 10);
}

/**
 * Reverts the timezone offset that may have been applied to a
 * `Date` Object twice. This is helpful if a date is selected as
 * a UTC timestamp but coerced into a locallized `Date` Object
 * which will cause the resulting object to be incorrect.
 *
 * @param {Date} date
 * @returns {Date}
 */
export function revertTimezoneOffset(date) {
    date.setTime(date.getTime() - date.getTimezoneOffset() * 60 * 1000);
    return date;
}
