/**
 * @param {string} string
 * @returns {string}
 */
export function encodeForCssSelector(string) {
    return string.replace(/([^a-zA-Z_\-0-9])/g, '\\$1');
}

/**
 * @param {string} attribute
 * @param {?string} value
 * @returns {string}
 */
export function attributeSelector(attribute, value = null) {
    let selector = encodeForCssSelector(attribute);
    if (value !== null) {
        selector += `="${value}"`;
    }
    return `[${selector}]`;
}
