import { onPageLoadComplete } from '@nimius/event-utility';

/**
 * @returns {Promise}
 */
function lazyLoadEventsResultListController() {
    return import(
        /* webpackChunkName: "toubiz-events" */
        '../../Scripts/toubiz-events/event-results-list-controller'
    ).then(all => all.EventsResultsListController);
}

onPageLoadComplete(async () => {
    const node = document.querySelector('[data-toubiz-results="events"]');
    if (node) {
        const EventsResultsListController = await lazyLoadEventsResultListController();
        new EventsResultsListController(node);
    }
});
