/**
 *
 * This sets the first list item of the tab navigation to aria-expanded="true"
 *
 */
export class ToubizTabNavigation {

    /**
     * @param {HTMLElement} element
     */
    constructor (element) {
        /** @private {HTMLElement} */
        this.element = element;

        /** @private {NodeList} */
        this.firstListItem = this.element.querySelector('li');

        if (this.firstListItem) {
            this.setAriaExpanded();
        }
    }

    setAriaExpanded() {
        this.firstListItem.setAttribute('aria-expanded', 'true');
    }
}
