import {
    Time,
    TimeRange,
    WeekdayBounds,
    WEEKDAYS,
    OpeningTimes,
    OpeningTimesCollection,
} from '@nimius/toubiz-opening-times-calculation';
import { expect } from 'chai';
import { mount } from 'vue-test-utils';
import OpeningTimesLinePreview from './opening-times-line-preview.vue';

describe ('opening-times-line-preview', () => {

    const times = {
        monday1am: (new Date(2020, 1, 3, 1, 0, 0)),
        monday1pm: (new Date(2020, 1, 3, 13, 0, 0)),
        monday11pm: (new Date(2020, 1, 3, 23, 0, 0)),
        tuesday1am: (new Date(2020, 1, 4, 1, 0, 0)),
    };

    let openingTimes = null;
    afterEach(() => openingTimes = null);
    beforeEach(() => {
        openingTimes = new OpeningTimesCollection([
            // Monday: 12:00 - 16:00, 22:00 - 02:00
            // Tuesday: 14:00 - 18:00

            new OpeningTimes({
                bounds: [ new WeekdayBounds([ WEEKDAYS.MONDAY ]) ],
                timeRanges: [
                    new TimeRange(Time.parse('12:00'), Time.parse('16:00')),
                    new TimeRange(Time.parse('22:00'), Time.parse('24:00')),
                ],
            }),
            new OpeningTimes({
                bounds: [ new WeekdayBounds([ WEEKDAYS.TUESDAY ]) ],
                timeRanges: [
                    new TimeRange(Time.parse('00:00'), Time.parse('02:00')),
                    new TimeRange(Time.parse('14:00'), Time.parse('18:00')),
                ],
            }),
        ]);
    });

    it ('should display opening times spilling into next day', () => {
        const wrapper = mount(OpeningTimesLinePreview, {
            propsData: {
                openingTimes: openingTimes,
                forDateAndTime: times.monday11pm,
            },
        });

        expect(wrapper.html()).to.include('02:00');
        expect(wrapper.html()).to.not.include('24:00');
    });

    it ('should display opening times spilling form previous day', () => {
        const wrapper = mount(OpeningTimesLinePreview, {
            propsData: {
                openingTimes: openingTimes,
                forDateAndTime: times.tuesday1am,
            },
        });

        expect(wrapper.html()).to.include('02:00');
    });

});
