export class TourDrawer {

    constructor (map) {
        this.map = map;
        this.polylines = [];
    }

    /**
     * @public
     * @param {Marker} marker
     * @param {boolean} fitBounds
     * @returns {void}
     */
    drawTourOntoMap(marker, fitBounds) {
        marker.polyline = marker.polyline || this.initializePolyline(marker.tour.color);

        const path = marker.tour.polygon.map(([ lat, lng ]) => ({ lat, lng }));

        marker.polyline.setPath(path);
        marker.polyline.setMap(this.map);

        this.polylines.push(marker.polyline);

        if (fitBounds) {
            this.fitBounds(path);
        }
    }

    /**
     * @public
     */
    clearTours () {
        for (const polyline of this.polylines) {
            polyline.setMap(null);
        }
        this.polylines = [];
    }

    /**
     * @private
     * @param {Array} path
     */
    fitBounds(path) {
        const bounds = new google.maps.LatLngBounds();
        for (const coordinates of path) {
            bounds.extend(coordinates);
        }
        this.map.fitBounds(bounds);
    }

    /**
     * @private
     * @param {string} color
     * @returns {google.maps.Polyline}
     */
    initializePolyline(color) {
        return new google.maps.Polyline({
            path: [],
            geodesic: true,
            strokeColor: color || '#FF6347',
            strokeOpacity: 1.0,
            strokeWeight: 3,
        });
    }

}
